/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.beans.BeansUtils;
import com.mchange.v2.c3p0.DriverManagerDataSource;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import com.mchange.v2.c3p0.impl.AbstractPoolBackedDataSource;
import com.mchange.v2.lang.ObjectUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Referenceable;
import javax.sql.DataSource;

public abstract class AbstractComboPooledDataSource
extends AbstractPoolBackedDataSource
implements PooledDataSource,
Serializable,
Referenceable {
    static final MLogger logger = MLog.getLogger(AbstractComboPooledDataSource.class);
    static final Set TO_STRING_IGNORE_PROPS = new HashSet<String>(Arrays.asList("connection", "lastAcquisitionFailureDefaultUser", "lastCheckinFailureDefaultUser", "lastCheckoutFailureDefaultUser", "lastConnectionTestFailureDefaultUser", "lastIdleTestFailureDefaultUser", "logWriter", "loginTimeout", "numBusyConnections", "numBusyConnectionsAllUsers", "numBusyConnectionsDefaultUser", "numConnections", "numConnectionsAllUsers", "numConnectionsDefaultUser", "numFailedCheckinsDefaultUser", "numFailedCheckoutsDefaultUser", "numFailedIdleTestsDefaultUser", "numIdleConnections", "numIdleConnectionsAllUsers", "numThreadsAwaitingCheckoutDefaultUser", "numIdleConnectionsDefaultUser", "numUnclosedOrphanedConnections", "numUnclosedOrphanedConnectionsAllUsers", "numUnclosedOrphanedConnectionsDefaultUser", "numUserPools", "effectivePropertyCycleDefaultUser", "parentLogger", "startTimeMillisDefaultUser", "statementCacheNumCheckedOutDefaultUser", "statementCacheNumCheckedOutStatementsAllUsers", "statementCacheNumConnectionsWithCachedStatementsAllUsers", "statementCacheNumConnectionsWithCachedStatementsDefaultUser", "statementCacheNumStatementsAllUsers", "statementCacheNumStatementsDefaultUser", "statementDestroyerNumConnectionsInUseAllUsers", "statementDestroyerNumConnectionsWithDeferredDestroyStatementsAllUsers", "statementDestroyerNumDeferredDestroyStatementsAllUsers", "statementDestroyerNumConnectionsInUseDefaultUser", "statementDestroyerNumConnectionsWithDeferredDestroyStatementsDefaultUser", "statementDestroyerNumDeferredDestroyStatementsDefaultUser", "statementDestroyerNumThreads", "statementDestroyerNumActiveThreads", "statementDestroyerNumIdleThreads", "statementDestroyerNumTasksPending", "threadPoolSize", "threadPoolNumActiveThreads", "threadPoolNumIdleThreads", "threadPoolNumTasksPending", "threadPoolStackTraces", "threadPoolStatus", "overrideDefaultUser", "overrideDefaultPassword", "password", "reference", "upTimeMillisDefaultUser", "user", "userOverridesAsString", "allUsers", "connectionPoolDataSource", "propertyChangeListeners", "vetoableChangeListeners"));
    transient DriverManagerDataSource dmds = new DriverManagerDataSource();
    transient WrapperConnectionPoolDataSource wcpds = new WrapperConnectionPoolDataSource();
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;

    private static boolean diff(int n, int n2) {
        return n != n2;
    }

    private static boolean diff(boolean bl, boolean bl2) {
        return bl != bl2;
    }

    private static boolean diff(Object object, Object object2) {
        return !ObjectUtils.eqOrBothNull(object, object2);
    }

    public AbstractComboPooledDataSource() {
        this(true);
    }

    public AbstractComboPooledDataSource(boolean bl) {
        super(bl);
        this.wcpds.setNestedDataSource(this.dmds);
        try {
            this.setConnectionPoolDataSource(this.wcpds);
        }
        catch (PropertyVetoException propertyVetoException) {
            logger.log(MLevel.WARNING, "Hunh??? This can't happen. We haven't set up any listeners to veto the property change yet!", propertyVetoException);
            throw new RuntimeException("Hunh??? This can't happen. We haven't set up any listeners to veto the property change yet! " + propertyVetoException);
        }
        this.setUpPropertyEvents();
    }

    private void setUpPropertyEvents() {
        VetoableChangeListener vetoableChangeListener = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                if ("connectionPoolDataSource".equals(string)) {
                    if (object instanceof WrapperConnectionPoolDataSource) {
                        DataSource dataSource = ((WrapperConnectionPoolDataSource)object).getNestedDataSource();
                        if (!(dataSource instanceof DriverManagerDataSource)) {
                            throw new PropertyVetoException(this.getClass().getName() + " requires that its unpooled DataSource  be set at all times, and that it be a com.mchange.v2.c3p0.DriverManagerDataSource. Bad: " + dataSource, propertyChangeEvent);
                        }
                    } else {
                        throw new PropertyVetoException(this.getClass().getName() + " requires that its ConnectionPoolDataSource  be set at all times, and that it be a com.mchange.v2.c3p0.WrapperConnectionPoolDataSource. Bad: " + object, propertyChangeEvent);
                    }
                }
            }
        };
        this.addVetoableChangeListener(vetoableChangeListener);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                if ("connectionPoolDataSource".equals(string)) {
                    AbstractComboPooledDataSource.this.updateLocalVarsFromCpdsProp();
                }
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
    }

    private void updateLocalVarsFromCpdsProp() {
        this.wcpds = (WrapperConnectionPoolDataSource)this.getConnectionPoolDataSource();
        this.dmds = (DriverManagerDataSource)this.wcpds.getNestedDataSource();
    }

    public AbstractComboPooledDataSource(String string) {
        this();
        this.initializeNamedConfig(string, true);
    }

    public String getDescription() {
        return this.dmds.getDescription();
    }

    public void setDescription(String string) {
        this.dmds.setDescription(string);
    }

    public String getDriverClass() {
        return this.dmds.getDriverClass();
    }

    public void setDriverClass(String string) throws PropertyVetoException {
        this.dmds.setDriverClass(string);
    }

    public boolean isForceUseNamedDriverClass() {
        return this.dmds.isForceUseNamedDriverClass();
    }

    public void setForceUseNamedDriverClass(boolean bl) {
        this.dmds.setForceUseNamedDriverClass(bl);
    }

    public String getJdbcUrl() {
        return this.dmds.getJdbcUrl();
    }

    public void setJdbcUrl(String string) {
        if (AbstractComboPooledDataSource.diff(this.dmds.getJdbcUrl(), string)) {
            this.dmds.setJdbcUrl(string);
            this.resetPoolManager(false);
        }
    }

    public Properties getProperties() {
        return this.dmds.getProperties();
    }

    public void setProperties(Properties properties) {
        if (AbstractComboPooledDataSource.diff(this.dmds.getProperties(), properties)) {
            this.dmds.setProperties(properties);
            this.resetPoolManager(false);
        }
    }

    public String getUser() {
        return this.dmds.getUser();
    }

    public void setUser(String string) {
        if (AbstractComboPooledDataSource.diff(this.dmds.getUser(), string)) {
            this.dmds.setUser(string);
            this.resetPoolManager(false);
        }
    }

    public String getPassword() {
        return this.dmds.getPassword();
    }

    public void setPassword(String string) {
        if (AbstractComboPooledDataSource.diff(this.dmds.getPassword(), string)) {
            this.dmds.setPassword(string);
            this.resetPoolManager(false);
        }
    }

    public int getCheckoutTimeout() {
        return this.wcpds.getCheckoutTimeout();
    }

    public void setCheckoutTimeout(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getCheckoutTimeout(), n)) {
            this.wcpds.setCheckoutTimeout(n);
            this.resetPoolManager(false);
        }
    }

    public int getConnectionIsValidTimeout() {
        return this.wcpds.getConnectionIsValidTimeout();
    }

    public void setConnectionIsValidTimeout(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getConnectionIsValidTimeout(), n)) {
            this.wcpds.setConnectionIsValidTimeout(n);
            this.resetPoolManager(false);
        }
    }

    public int getAcquireIncrement() {
        return this.wcpds.getAcquireIncrement();
    }

    public void setAcquireIncrement(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getAcquireIncrement(), n)) {
            this.wcpds.setAcquireIncrement(n);
            this.resetPoolManager(false);
        }
    }

    public int getAcquireRetryAttempts() {
        return this.wcpds.getAcquireRetryAttempts();
    }

    public void setAcquireRetryAttempts(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getAcquireRetryAttempts(), n)) {
            this.wcpds.setAcquireRetryAttempts(n);
            this.resetPoolManager(false);
        }
    }

    public int getAcquireRetryDelay() {
        return this.wcpds.getAcquireRetryDelay();
    }

    public void setAcquireRetryDelay(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getAcquireRetryDelay(), n)) {
            this.wcpds.setAcquireRetryDelay(n);
            this.resetPoolManager(false);
        }
    }

    public boolean isAutoCommitOnClose() {
        return this.wcpds.isAutoCommitOnClose();
    }

    public void setAutoCommitOnClose(boolean bl) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.isAutoCommitOnClose(), bl)) {
            this.wcpds.setAutoCommitOnClose(bl);
            this.resetPoolManager(false);
        }
    }

    public String getContextClassLoaderSource() {
        return this.wcpds.getContextClassLoaderSource();
    }

    public void setContextClassLoaderSource(String string) throws PropertyVetoException {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getContextClassLoaderSource(), string)) {
            this.wcpds.setContextClassLoaderSource(string);
            this.resetPoolManager(false);
        }
    }

    public String getConnectionTesterClassName() {
        return this.wcpds.getConnectionTesterClassName();
    }

    public void setConnectionTesterClassName(String string) throws PropertyVetoException {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getConnectionTesterClassName(), string)) {
            this.wcpds.setConnectionTesterClassName(string);
            this.resetPoolManager(false);
        }
    }

    public String getTaskRunnerFactoryClassName() {
        return this.wcpds.getTaskRunnerFactoryClassName();
    }

    public void setTaskRunnerFactoryClassName(String string) throws PropertyVetoException {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getTaskRunnerFactoryClassName(), string)) {
            this.wcpds.setTaskRunnerFactoryClassName(string);
            this.resetPoolManager(false);
        }
    }

    public String getAutomaticTestTable() {
        return this.wcpds.getAutomaticTestTable();
    }

    public void setAutomaticTestTable(String string) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getAutomaticTestTable(), string)) {
            this.wcpds.setAutomaticTestTable(string);
            this.resetPoolManager(false);
        }
    }

    public boolean isForceIgnoreUnresolvedTransactions() {
        return this.wcpds.isForceIgnoreUnresolvedTransactions();
    }

    public void setForceIgnoreUnresolvedTransactions(boolean bl) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.isForceIgnoreUnresolvedTransactions(), bl)) {
            this.wcpds.setForceIgnoreUnresolvedTransactions(bl);
            this.resetPoolManager(false);
        }
    }

    public boolean isPrivilegeSpawnedThreads() {
        return this.wcpds.isPrivilegeSpawnedThreads();
    }

    public void setPrivilegeSpawnedThreads(boolean bl) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.isPrivilegeSpawnedThreads(), bl)) {
            this.wcpds.setPrivilegeSpawnedThreads(bl);
            this.resetPoolManager(false);
        }
    }

    public int getIdleConnectionTestPeriod() {
        return this.wcpds.getIdleConnectionTestPeriod();
    }

    public void setIdleConnectionTestPeriod(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getIdleConnectionTestPeriod(), n)) {
            this.wcpds.setIdleConnectionTestPeriod(n);
            this.resetPoolManager(false);
        }
    }

    public int getInitialPoolSize() {
        return this.wcpds.getInitialPoolSize();
    }

    public void setInitialPoolSize(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getInitialPoolSize(), n)) {
            this.wcpds.setInitialPoolSize(n);
            this.resetPoolManager(false);
        }
    }

    public int getMaxIdleTime() {
        return this.wcpds.getMaxIdleTime();
    }

    public void setMaxIdleTime(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getMaxIdleTime(), n)) {
            this.wcpds.setMaxIdleTime(n);
            this.resetPoolManager(false);
        }
    }

    public int getMaxPoolSize() {
        return this.wcpds.getMaxPoolSize();
    }

    public void setMaxPoolSize(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getMaxPoolSize(), n)) {
            this.wcpds.setMaxPoolSize(n);
            this.resetPoolManager(false);
        }
    }

    public int getMaxStatements() {
        return this.wcpds.getMaxStatements();
    }

    public void setMaxStatements(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getMaxStatements(), n)) {
            this.wcpds.setMaxStatements(n);
            this.resetPoolManager(false);
        }
    }

    public int getMaxStatementsPerConnection() {
        return this.wcpds.getMaxStatementsPerConnection();
    }

    public void setMaxStatementsPerConnection(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getMaxStatementsPerConnection(), n)) {
            this.wcpds.setMaxStatementsPerConnection(n);
            this.resetPoolManager(false);
        }
    }

    public int getMinPoolSize() {
        return this.wcpds.getMinPoolSize();
    }

    public void setMinPoolSize(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getMinPoolSize(), n)) {
            this.wcpds.setMinPoolSize(n);
            this.resetPoolManager(false);
        }
    }

    public String getOverrideDefaultUser() {
        return this.wcpds.getOverrideDefaultUser();
    }

    public void setOverrideDefaultUser(String string) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getOverrideDefaultUser(), string)) {
            this.wcpds.setOverrideDefaultUser(string);
            this.resetPoolManager(false);
        }
    }

    public String getOverrideDefaultPassword() {
        return this.wcpds.getOverrideDefaultPassword();
    }

    public void setOverrideDefaultPassword(String string) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getOverrideDefaultPassword(), string)) {
            this.wcpds.setOverrideDefaultPassword(string);
            this.resetPoolManager(false);
        }
    }

    public int getPropertyCycle() {
        return this.wcpds.getPropertyCycle();
    }

    public void setPropertyCycle(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getPropertyCycle(), n)) {
            this.wcpds.setPropertyCycle(n);
            this.resetPoolManager(false);
        }
    }

    public boolean isBreakAfterAcquireFailure() {
        return this.wcpds.isBreakAfterAcquireFailure();
    }

    public void setBreakAfterAcquireFailure(boolean bl) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.isBreakAfterAcquireFailure(), bl)) {
            this.wcpds.setBreakAfterAcquireFailure(bl);
            this.resetPoolManager(false);
        }
    }

    public boolean isTestConnectionOnCheckout() {
        return this.wcpds.isTestConnectionOnCheckout();
    }

    public void setTestConnectionOnCheckout(boolean bl) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.isTestConnectionOnCheckout(), bl)) {
            this.wcpds.setTestConnectionOnCheckout(bl);
            this.resetPoolManager(false);
        }
    }

    public boolean isTestConnectionOnCheckin() {
        return this.wcpds.isTestConnectionOnCheckin();
    }

    public void setTestConnectionOnCheckin(boolean bl) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.isTestConnectionOnCheckin(), bl)) {
            this.wcpds.setTestConnectionOnCheckin(bl);
            this.resetPoolManager(false);
        }
    }

    public boolean isAttemptResurrectOnCheckin() {
        return this.wcpds.isAttemptResurrectOnCheckin();
    }

    public void setAttemptResurrectOnCheckin(boolean bl) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.isAttemptResurrectOnCheckin(), bl)) {
            this.wcpds.setAttemptResurrectOnCheckin(bl);
            this.resetPoolManager(false);
        }
    }

    public String getPreferredTestQuery() {
        return this.wcpds.getPreferredTestQuery();
    }

    public void setPreferredTestQuery(String string) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getPreferredTestQuery(), string)) {
            this.wcpds.setPreferredTestQuery(string);
            this.resetPoolManager(false);
        }
    }

    public int getMaxAdministrativeTaskTime() {
        return this.wcpds.getMaxAdministrativeTaskTime();
    }

    public void setMaxAdministrativeTaskTime(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getMaxAdministrativeTaskTime(), n)) {
            this.wcpds.setMaxAdministrativeTaskTime(n);
            this.resetPoolManager(false);
        }
    }

    public int getMaxIdleTimeExcessConnections() {
        return this.wcpds.getMaxIdleTimeExcessConnections();
    }

    public void setMaxIdleTimeExcessConnections(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getMaxIdleTimeExcessConnections(), n)) {
            this.wcpds.setMaxIdleTimeExcessConnections(n);
            this.resetPoolManager(false);
        }
    }

    public int getMaxConnectionAge() {
        return this.wcpds.getMaxConnectionAge();
    }

    public void setMaxConnectionAge(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getMaxConnectionAge(), n)) {
            this.wcpds.setMaxConnectionAge(n);
            this.resetPoolManager(false);
        }
    }

    public String getConnectionCustomizerClassName() {
        return this.wcpds.getConnectionCustomizerClassName();
    }

    public void setConnectionCustomizerClassName(String string) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getConnectionCustomizerClassName(), string)) {
            this.wcpds.setConnectionCustomizerClassName(string);
            this.resetPoolManager(false);
        }
    }

    public int getUnreturnedConnectionTimeout() {
        return this.wcpds.getUnreturnedConnectionTimeout();
    }

    public void setUnreturnedConnectionTimeout(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getUnreturnedConnectionTimeout(), n)) {
            this.wcpds.setUnreturnedConnectionTimeout(n);
            this.resetPoolManager(false);
        }
    }

    public String getUserOverridesAsString() {
        return this.wcpds.getUserOverridesAsString();
    }

    public void setUserOverridesAsString(String string) throws PropertyVetoException {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getUserOverridesAsString(), string)) {
            this.wcpds.setUserOverridesAsString(string);
            this.resetPoolManager(false);
        }
    }

    public Map getUserOverrides() {
        return this.wcpds.getUserOverrides();
    }

    public boolean isDebugUnreturnedConnectionStackTraces() {
        return this.wcpds.isDebugUnreturnedConnectionStackTraces();
    }

    public void setDebugUnreturnedConnectionStackTraces(boolean bl) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.isDebugUnreturnedConnectionStackTraces(), bl)) {
            this.wcpds.setDebugUnreturnedConnectionStackTraces(bl);
            this.resetPoolManager(false);
        }
    }

    public boolean isForceSynchronousCheckins() {
        return this.wcpds.isForceSynchronousCheckins();
    }

    public void setForceSynchronousCheckins(boolean bl) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.isForceSynchronousCheckins(), bl)) {
            this.wcpds.setForceSynchronousCheckins(bl);
            this.resetPoolManager(false);
        }
    }

    public int getStatementCacheNumDeferredCloseThreads() {
        return this.wcpds.getStatementCacheNumDeferredCloseThreads();
    }

    public void setStatementCacheNumDeferredCloseThreads(int n) {
        if (AbstractComboPooledDataSource.diff(this.wcpds.getStatementCacheNumDeferredCloseThreads(), n)) {
            this.wcpds.setStatementCacheNumDeferredCloseThreads(n);
            this.resetPoolManager(false);
        }
    }

    @Override
    public String getFactoryClassLocation() {
        return super.getFactoryClassLocation();
    }

    @Override
    public void setFactoryClassLocation(String string) {
        if (AbstractComboPooledDataSource.diff(this.dmds.getFactoryClassLocation(), string) || AbstractComboPooledDataSource.diff(this.wcpds.getFactoryClassLocation(), string) || AbstractComboPooledDataSource.diff(super.getFactoryClassLocation(), string)) {
            this.dmds.setFactoryClassLocation(string);
            this.wcpds.setFactoryClassLocation(string);
            super.setFactoryClassLocation(string);
        }
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean bl) {
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(512);
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append(" [ ");
            try {
                BeansUtils.appendPropNamesAndValues(stringBuffer, this, TO_STRING_IGNORE_PROPS);
            }
            catch (Exception exception) {
                stringBuffer.append(exception.toString());
            }
            stringBuffer.append(" ]");
            return stringBuffer.toString();
        }
        return this.getClass().getName() + "[ identityToken -> " + this.getIdentityToken() + ", dataSourceName -> " + this.getDataSourceName() + " ]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeShort(1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        short s = objectInputStream.readShort();
        switch (s) {
            case 1: {
                this.updateLocalVarsFromCpdsProp();
                this.setUpPropertyEvents();
                break;
            }
            default: {
                throw new IOException("Unsupported Serialized Version: " + s);
            }
        }
    }

    private boolean isWrapperForDmds(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(this.dmds.getClass()) || this.dmds.isWrapperFor(clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return this.isWrapperForDmds(clazz) || this.isWrapperForThis(clazz);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperForDmds(clazz)) {
            return this.dmds.unwrap(clazz);
        }
        if (this.isWrapperForThis(clazz)) {
            return (T)this;
        }
        throw new SQLException(this + " is not a wrapper for or implementation of " + clazz.getName());
    }
}

