/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.CallableExpressionCompiler;
import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.StaticFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;

public class StaticFunctionCallCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        StaticFunctionCall call = (StaticFunctionCall)expression;
        Function function = call.getTargetFunction();
        ArrayList<Expression> subExpressions = new ArrayList<Expression>(5);
        for (Operand o : expression.operands()) {
            subExpressions.add(o.getChildExpression());
        }
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        StaticFunctionCallCompiler.visitAnnotation(compiler, "StaticFunctionCallCompiler");
        StaticFunctionCallCompiler.visitLineNumber(compiler, ga, expression);
        int arrVar = CallableExpressionCompiler.buildArgumentArray(compiler, ga, methodInfo, subExpressions);
        StaticFunctionCallCompiler.allocateStatic(compiler, function);
        compiler.generateGetContext();
        ga.loadLocal(arrVar);
        ga.invokeInstanceMethod(Function.class, "call", XPathContext.class, Sequence[].class);
        ga.invokeInstanceMethod(Sequence.class, "iterate", new Class[0]);
        StaticFunctionCallCompiler.visitAnnotation(compiler, "StaticFunctionCallCompiler-Done");
    }
}

