/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.VariableReferenceCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.optim.IndexedFilterExpression;
import com.saxonica.ee.optim.IndexedValue;
import com.saxonica.ee.optim.SearchableValue;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.Bindery;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.EmptySequence;

public class IndexedFilterExpressionCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        IndexedFilterExpression indexedFilter = (IndexedFilterExpression)expression;
        Expression base = indexedFilter.getBaseExpression();
        if (!(base instanceof VariableReference)) {
            throw new CannotCompileException("IndexedFilterExpression has been rewritten", false);
        }
        VariableReference start = (VariableReference)base;
        VariableReferenceCompiler.genEvaluateVariable(compiler, ga, start);
        int baseVar = methodInfo.allocateLocal(GroundedValue.class);
        ga.storeLocal(baseVar);
        LabelInfo notEmpty = methodInfo.newLabel("IXFnotEmpty");
        LabelInfo isSearchableValue = methodInfo.newLabel("isIdxVal");
        LabelInfo end = methodInfo.newLabel("endIxFlt");
        LabelInfo notZero = methodInfo.newLabel("notZero");
        ga.loadLocal(baseVar);
        ga.ifNotInstance(EmptySequence.class, notEmpty);
        ga.invokeStaticMethod(EmptyIterator.class, "getInstance", new Class[0]);
        ga.checkClass(SequenceIterator.class);
        ga.goTo(end);
        methodInfo.placeLabel(notEmpty);
        ga.loadLocal(baseVar);
        ga.ifInstance(SearchableValue.class, isSearchableValue);
        ga.loadLocal(baseVar);
        ga.invokeInstanceMethod(Sequence.class, "iterate", new Class[0]);
        ga.invokeStaticMethod(SearchableValue.class, "makeSearchableValue", SequenceIterator.class);
        ga.storeLocal(baseVar);
        Binding binding = start.getBinding();
        if (binding instanceof LocalBinding) {
            compiler.generateGetContext();
            ga.push(((LocalBinding)binding).getLocalSlotNumber());
            ga.loadLocal(baseVar);
            ga.invokeInstanceMethod(XPathContext.class, "setLocalVariable", Integer.TYPE, Sequence.class);
        } else if (binding instanceof GlobalVariable) {
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getController", new Class[0]);
            IndexedFilterExpressionCompiler.allocateStatic(compiler, binding);
            ga.invokeInstanceMethod(Actor.class, "getPackageData", new Class[0]);
            ga.invokeInstanceMethod(Controller.class, "getBindery", PackageData.class);
            IndexedFilterExpressionCompiler.allocateStatic(compiler, binding);
            ga.checkClass(GlobalVariable.class);
            ga.loadLocal(baseVar);
            ga.invokeInstanceMethod(Bindery.class, "setGlobalVariable", GlobalVariable.class, GroundedValue.class);
        } else {
            ga.newInstance(Type.getType(IndexedValue.class));
            ga.dup();
            ga.loadLocal(baseVar);
            ga.invokeInstanceMethod(Sequence.class, "iterate", new Class[0]);
            ga.invokeConstructor(IndexedValue.class, SequenceIterator.class);
            ga.storeLocal(baseVar);
        }
        methodInfo.placeLabel(isSearchableValue);
        ga.loadLocal(baseVar);
        ga.checkClass(SearchableValue.class);
        ga.invokeInstanceMethod(SearchableValue.class, "getLength", new Class[0]);
        ga.push(0);
        ga.ifICmp(154, notZero.label());
        ga.invokeStaticMethod(EmptyIterator.class, "getInstance", new Class[0]);
        ga.goTo(end);
        methodInfo.placeLabel(notZero);
        Expression use = indexedFilter.getUseExpression();
        Expression valExpr = indexedFilter.getSearchExpression();
        ga.loadLocal(baseVar);
        ga.checkClass(SearchableValue.class);
        IndexedFilterExpressionCompiler.allocateStatic(compiler, use);
        compiler.compileToIterator(valExpr);
        ga.push(indexedFilter.isConvertUntypedToOther());
        ga.push(false);
        AtomicComparer comparer = indexedFilter.getComparer();
        IndexedFilterExpressionCompiler.allocateStatic(compiler, comparer);
        compiler.generateGetContext();
        ga.invokeInstanceMethod(AtomicComparer.class, "provideContext", XPathContext.class);
        compiler.generateGetContext();
        ga.invokeInstanceMethod(SearchableValue.class, "findItems", Expression.class, SequenceIterator.class, Boolean.TYPE, Boolean.TYPE, AtomicComparer.class, XPathContext.class);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(baseVar);
    }
}

