/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.domino;

import com.saxonica.ee.domino.DominoNode;
import com.saxonica.ee.domino.DominoTree;
import java.util.function.IntPredicate;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;

final class PrecedingIterator
implements AxisIterator {
    private DominoTree tree;
    private DominoNode startNode;
    private DominoNode current;
    private NodeTest test;
    private int nextAncestorDepth;
    private boolean includeAncestors;
    private final IntPredicate matcher;

    public PrecedingIterator(DominoTree doc, DominoNode node, NodeTest nodeTest, boolean includeAncestors) {
        this.includeAncestors = includeAncestors;
        this.test = nodeTest;
        this.tree = doc;
        this.current = this.startNode = node;
        this.nextAncestorDepth = doc.depth[node.getNodeNr()] - 1;
        this.matcher = nodeTest.getMatcher(doc);
    }

    @Override
    public NodeInfo next() {
        if (this.current == null) {
            return null;
        }
        int nextNodeNr = this.current.getNodeNr();
        do {
            if (!this.includeAncestors) {
                --nextNodeNr;
                while (this.nextAncestorDepth >= 0 && this.tree.depth[nextNodeNr] == this.nextAncestorDepth) {
                    if (this.nextAncestorDepth-- <= 0) {
                        this.current = null;
                        return null;
                    }
                    --nextNodeNr;
                }
            } else {
                if (this.tree.depth[nextNodeNr] == 0) {
                    this.current = null;
                    return null;
                }
                --nextNodeNr;
            }
            if (!this.matcher.test(nextNodeNr)) continue;
            this.current = this.tree.getNode(nextNodeNr);
            return this.current;
        } while (this.tree.depth[nextNodeNr] != 0);
        this.current = null;
        return null;
    }
}

