/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode.converter;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.converter.ConverterCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;

public class StringToIntegerCompiler
extends ConverterCompiler.GenericConverterCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        CastExpression cast = (CastExpression)expression;
        Expression base = cast.getBaseExpression();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        boolean allowsEmpty = Cardinality.allowsZero(cast.getCardinality());
        ExpressionCompiler.visitAnnotation(compiler, "StringToIntegerConverter-Item");
        if (allowsEmpty) {
            LabelInfo empty = methodInfo.newLabel("returnEmpty");
            LabelInfo end = methodInfo.newLabel("end");
            compiler.compileToPrimitive(base, CharSequence.class, new OnEmpty.UnwindAndJump(empty));
            ga.invokeStaticMethod(IntegerValue.class, "stringToInteger", CharSequence.class);
            ga.invokeInstanceMethod(ConversionResult.class, "asAtomic", new Class[0]);
            ga.checkClass(IntegerValue.class);
            ga.goTo(end);
            methodInfo.placeLabel(empty);
            ga.pushNull();
            methodInfo.placeLabel(end);
        } else {
            compiler.compileToPrimitive(base, CharSequence.class, OnEmpty.RETURN_NULL);
            ga.invokeStaticMethod(IntegerValue.class, "stringToInteger", CharSequence.class);
            ga.invokeInstanceMethod(ConversionResult.class, "asAtomic", new Class[0]);
            ga.checkClass(IntegerValue.class);
        }
    }
}

