/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.config;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.optim.MultithreadedItemMappingIterator;
import com.saxonica.ee.trans.ThreadManagerEE;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class MultithreadingFactory {
    EnterpriseConfiguration config;

    public MultithreadingFactory(EnterpriseConfiguration config) {
        this.config = config;
    }

    public <F extends Item<?>, T extends Item<?>> SequenceIterator<T> makeMultithreadedItemMappingIterator(SequenceIterator<F> base, ItemMappingFunction<F, T> action) throws XPathException {
        return new MultithreadedItemMappingIterator<F, T>(base, action);
    }

    public XPathContextMajor.ThreadManager makeThreadManager() {
        return new ThreadManagerEE(this.config);
    }

    public ExecutorService makeExecutorService(int threads) {
        return Executors.newFixedThreadPool(threads);
    }

    public Thread makeThread(Runnable runnable) {
        return new Thread(runnable);
    }
}

