/*
 * Decompiled with CFR 0.152.
 */
package experimental.analyzer;

import experimental.analyzer.AnalyzerReading;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import marmot.core.Sequence;
import marmot.core.Token;
import marmot.morph.Word;
import marmot.morph.io.SentenceReader;
import marmot.util.Mutable;

public class AnalyzerInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String form_;
    private Collection<AnalyzerReading> readings_;

    public AnalyzerInstance(Collection<Token> sequence) {
        this.form_ = null;
        HashSet<AnalyzerReading> tags = new HashSet<AnalyzerReading>();
        for (Token token2 : sequence) {
            Word word = (Word)token2;
            if (this.form_ == null) {
                this.form_ = word.getWordForm();
            }
            assert (this.form_.equals(word.getWordForm()));
            AnalyzerReading tag = new AnalyzerReading(word);
            tags.add(tag);
        }
        this.readings_ = new ArrayList<AnalyzerReading>(tags);
    }

    public AnalyzerInstance(String form, Collection<AnalyzerReading> readings) {
        this.form_ = form;
        this.readings_ = readings;
    }

    public static Collection<AnalyzerInstance> getInstances(String filename) {
        LinkedList<AnalyzerInstance> list = new LinkedList<AnalyzerInstance>();
        for (Sequence sequence : new SentenceReader(filename)) {
            list.add(new AnalyzerInstance(sequence));
        }
        return list;
    }

    public static Collection<AnalyzerInstance> getTreebankInstances(String filename) {
        HashMap<String, Map> map2 = new HashMap<String, Map>();
        for (Sequence sequence : new SentenceReader(filename)) {
            for (Token token2 : sequence) {
                Word word = (Word)token2;
                Map instance = map2.computeIfAbsent(word.getWordForm(), k -> new HashMap());
                AnalyzerReading reading = new AnalyzerReading(word);
                Mutable i = instance.computeIfAbsent(reading, k -> new Mutable<Integer>(0));
                i.set((Integer)i.get() + 1);
            }
        }
        LinkedList<AnalyzerInstance> list = new LinkedList<AnalyzerInstance>();
        for (Map.Entry entry : map2.entrySet()) {
            String word = (String)entry.getKey();
            Map m4 = (Map)entry.getValue();
            LinkedList<AnalyzerReading> readings = new LinkedList<AnalyzerReading>();
            for (Map.Entry m_entry : m4.entrySet()) {
                AnalyzerReading reading = (AnalyzerReading)m_entry.getKey();
                Mutable i = (Mutable)m_entry.getValue();
                reading.setCount((Integer)i.get());
                readings.add(reading);
            }
            list.add(new AnalyzerInstance(word, readings));
        }
        return list;
    }

    public String getForm() {
        return this.form_;
    }

    public Collection<AnalyzerReading> getReadings() {
        return this.readings_;
    }
}

