/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.ComponentInversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamableUserFunction;
import com.saxonica.ee.stream.StreamingPatternMaker;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.Watch;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.UType;

public class ShallowDescentFunctionCallAdjunct
extends TransmissionAdjunct {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        if (reasons == null) {
            reasons = new ArrayList<String>();
        }
        UserFunctionCall exp = (UserFunctionCall)this.getExpression();
        UserFunction target = exp.getFunction();
        PostureAndSweep ps0 = Streamability.getStreamability(exp.getArg(0), contextInfo, reasons);
        Posture p0 = ps0.getPosture();
        if (p0 != Posture.STRIDING && p0 != Posture.GROUNDED) {
            reasons.add("Posture of first argument to a shallow-descent function must be striding or grounded");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        PostureAndSweep ps1 = PostureAndSweep.GROUNDED_AND_MOTIONLESS;
        if (exp.getOperanda().getNumberOfOperands() > 1) {
            RebindingMap rebindings = new RebindingMap();
            Expression[] children = new Expression[exp.getOperanda().getNumberOfOperands() - 1];
            boolean interesting = false;
            for (int i = 0; i < children.length; ++i) {
                Expression arg = exp.getArg(i + 1);
                PostureAndSweep ps = Streamability.getStreamability(arg, contextInfo, reasons);
                if (!ps.equals(PostureAndSweep.GROUNDED_AND_MOTIONLESS)) {
                    interesting = true;
                }
                children[i] = arg.copy(rebindings);
            }
            if (interesting) {
                Block block = new Block(children);
                ArrayList<Operand> operands = new ArrayList<Operand>(children.length);
                for (int i = 0; i < children.length; ++i) {
                    OperandRole original = exp.getOperanda().getOperand(i + 1).getOperandRole();
                    OperandUsage usage = Operand.typeDeterminedUsage(target.getArgumentType(i + 1).getPrimaryType());
                    OperandRole role = new OperandRole(original.getProperties(), usage);
                    Operand o2 = new Operand(children[i], block, role);
                    operands.add(o2);
                }
                ps1 = Streamability.generalStreamabilityRules(block, operands, contextInfo, reasons);
            }
        }
        if (ps1.getPosture() != Posture.GROUNDED) {
            reasons.add("Arguments after the first must be grounded");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (ps0.getSweep() == Sweep.CONSUMING && ps1.getSweep() == Sweep.CONSUMING) {
            reasons.add("More than one argument is consuming");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (ps0.getSweep() == Sweep.FREE_RANGING || ps1.getSweep() == Sweep.FREE_RANGING) {
            reasons.add("All arguments must be streamable");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (p0 == Posture.GROUNDED) {
            return new PostureAndSweep(Posture.GROUNDED, Sweep.wider(ps0.getSweep(), ps1.getSweep()));
        }
        if (target.getArgumentType(0).getPrimaryType().getUType().intersection(UType.DOCUMENT.union(UType.ELEMENT)).equals(UType.VOID)) {
            return new PostureAndSweep(p0, ps0.getSweep());
        }
        if (exp.getArg(0).getItemType().getUType().intersection(UType.DOCUMENT.union(UType.ELEMENT)).equals(UType.VOID)) {
            return new PostureAndSweep(p0, ps0.getSweep());
        }
        return new PostureAndSweep(p0, Sweep.CONSUMING);
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        UserFunctionCall instruction = (UserFunctionCall)this.getExpression();
        Expression select = instruction.getArg(0);
        final Pattern selection = StreamingPatternMaker.makeStreamingPattern(select, this.getConfiguration(), null);
        if (selection != null) {
            return new WatchMaker(){

                @Override
                public Trigger makeWatch(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
                    ShallowDescentFunctionCallAction action = new ShallowDescentFunctionCallAction(ShallowDescentFunctionCallAdjunct.this.getExpression(), out, context);
                    action.setWatchManager(watchManager);
                    return new Trigger(selection, action, context);
                }
            };
        }
        return null;
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        ShallowDescentFunctionCallAction action = new ShallowDescentFunctionCallAction(this.getExpression(), out, context);
        action.setWatchManager(watchManager);
        return action;
    }

    private static class ShallowDescentFunctionCallAction
    extends ItemFeed {
        private XPathContextMajor localContext;
        private WatchManager watchManager;
        private StreamableUserFunction targetFunction;
        private Watch innerWatch;
        private boolean started;

        public ShallowDescentFunctionCallAction(Expression functionCall, Feed out, XPathContext context) {
            super(functionCall, out, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            UserFunctionCall exp = (UserFunctionCall)this.getExpression();
            Component target = exp.getTargetComponent(this.getContext());
            this.targetFunction = (StreamableUserFunction)target.getActor();
            this.targetFunction.makeInversion();
            this.localContext = this.getContext().newContext();
            this.localContext.setCurrentComponent(target);
            Sequence[] args = exp.evaluateArguments(this.getContext(), true);
            this.localContext.setStackFrame(this.targetFunction.getStackFrameMap(), args);
            this.started = false;
        }

        public void setWatchManager(WatchManager watchManager) {
            this.watchManager = watchManager;
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            XPathContextMajor context = this.localContext;
            context.setLocalVariable(0, node);
            this.start();
            this.innerWatch.setAnchorNode(node);
            this.watchManager.addWatch(this.innerWatch, false);
            return null;
        }

        private void start() throws XPathException {
            if (!this.started) {
                this.started = true;
                ComponentInversion inversion = this.targetFunction.getInversion();
                this.innerWatch = inversion.getWatch(this.watchManager, this.getResult(), this.localContext);
                this.innerWatch.open(new Terminator());
            }
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            if (!this.hasFailed()) {
                XPathContextMajor context = this.localContext;
                context.setLocalVariable(0, item);
                this.start();
                ((Trigger)this.innerWatch).getAction().processItem(item);
            }
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            this.watchManager.removeWatch(this.innerWatch);
        }

        @Override
        public void close() throws XPathException {
            this.start();
            this.innerWatch.close();
            super.close();
        }
    }
}

