/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Orphan;

public class SimpleNodeConstructorFeed
extends ItemFeed {
    private FastStringBuffer buffer = new FastStringBuffer(100);
    private boolean disableOutputEscaping;

    public SimpleNodeConstructorFeed(Expression expr, Feed result, XPathContext context) {
        super(expr, result, context);
        this.disableOutputEscaping = expr instanceof ValueOf && ((ValueOf)expr).isDisableOutputEscaping();
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        if (!this.hasFailed()) {
            this.buffer.append(item.getStringValueCS());
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.hasFailed()) {
            NodeName nameCode;
            SimpleNodeConstructor constructor = (SimpleNodeConstructor)this.getExpression();
            try {
                nameCode = constructor.evaluateNodeName(this.getContext());
            }
            catch (XPathException e) {
                this.dynamicError(e);
                return;
            }
            Orphan node = new Orphan(this.getContext().getConfiguration());
            node.setNodeKind((short)constructor.getItemType().getPrimitiveType());
            node.setNodeName(nameCode);
            node.setStringValue(this.buffer);
            if (this.disableOutputEscaping) {
                node.setDisableOutputEscaping(true);
            }
            this.buffer = new FastStringBuffer(100);
            this.getResult().processItem(node);
            super.close();
        }
    }
}

