/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.watch;

import com.saxonica.ee.stream.feed.SnapshotFeed;
import com.saxonica.ee.stream.om.FleetingDocumentNode;
import com.saxonica.ee.stream.om.FleetingElementNode;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.AccumulatorWatch;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.Watch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationException;

public class WatchManager
extends SequenceReceiver
implements NamespaceResolver {
    private static final boolean TRACING = false;
    private boolean startDocumentPending;
    private int startDocumentProperties;
    private FleetingDocumentNode documentNode;
    private StartTagBuffer startTagBuffer;
    private FleetingParentNode[] elementStack = new FleetingParentNode[20];
    private int[] receiverCountStack = new int[20];
    private int[] namespaceCountStack = new int[20];
    protected int elementStackTop = 0;
    private NamespaceBinding[] namespaceStack = new NamespaceBinding[20];
    private int namespaceStackTop = 0;
    protected List<Watch> watchList = new ArrayList<Watch>(10);
    protected Stack<List<ClosedownAction>> activeWatchStack = new Stack();
    private Stack<Receiver> activeReceiverStack = new Stack();
    private Location lastLocationId = ExplicitLocation.UNKNOWN_LOCATION;
    private XPathContext context;
    private Map<Accumulator, AccumulatorWatch> accumulatorWatchMap;
    private List<GroupingScope> capturingScopes = new ArrayList<GroupingScope>();

    private void trace(String message) {
    }

    public WatchManager(PipelineConfiguration pipe) {
        super(pipe);
        Configuration config = pipe.getConfiguration();
        this.context = config.getConversionContext();
        long docNr = config.getDocumentNumberAllocator().allocateStreamedDocumentNumber();
        this.documentNode = new FleetingDocumentNode(docNr);
        this.documentNode.setConfiguration(config);
    }

    public void setStartTagBuffer(StartTagBuffer stb) {
        this.startTagBuffer = stb;
    }

    public StartTagBuffer getStartTagBuffer() {
        return this.startTagBuffer;
    }

    public void setXPathContext(XPathContext context) {
        this.context = context;
    }

    public XPathContext getXPathContext() {
        return this.context;
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        throw new UnsupportedOperationException("WatchManager does not implement append()");
    }

    @Override
    public void close() throws XPathException {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.startDocumentPending = true;
        this.startDocumentProperties = properties;
    }

    private void deferredStartDocument() throws XPathException {
        this.documentNode.setSystemId(this.getSystemId());
        this.documentNode.setAccumulatorWatchMap(this.accumulatorWatchMap);
        this.elementStack[this.elementStackTop] = this.documentNode;
        this.receiverCountStack[this.elementStackTop] = 0;
        this.namespaceCountStack[this.elementStackTop++] = 0;
        ArrayList<ClosedownAction> activeWatchList = new ArrayList<ClosedownAction>(4);
        this.activeWatchStack.push(activeWatchList);
        for (int i = 0; i < this.watchList.size(); ++i) {
            Watch watch = this.watchList.get(i);
            boolean matches = watch.matchesNode(this.documentNode, this.context);
            if (!matches) continue;
            ClosedownAction action = new ClosedownAction(watch, 0);
            activeWatchList.add(action);
            Receiver out = watch.startSelectedParentNode(this.documentNode, ExplicitLocation.UNKNOWN_LOCATION);
            if (out == null) continue;
            out.open();
            this.activeReceiverStack.push(out);
            int n = this.elementStackTop - 1;
            this.receiverCountStack[n] = this.receiverCountStack[n] + 1;
        }
        for (Receiver out : this.activeReceiverStack) {
            this.copyUnparsedEntities(out);
            out.startDocument(this.startDocumentProperties);
        }
        this.documentNode.copyInitialCommentsAndProcessingInstructions(this);
    }

    private void copyUnparsedEntities(Receiver out) throws XPathException {
        if (this.documentNode != null) {
            Iterator<String> names = this.documentNode.getUnparsedEntityNames();
            while (names.hasNext()) {
                String name = names.next();
                String[] entity = this.documentNode.getUnparsedEntity(name);
                out.setUnparsedEntity(name, entity[0], entity[1]);
            }
        }
    }

    @Override
    public void startElement(NodeName elementName, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.trace("startElement " + elementName);
        if (this.startDocumentPending) {
            this.startDocumentPending = false;
            this.deferredStartDocument();
        }
        try {
            ValidationException ve = null;
            this.ensureStackSpace();
            FleetingElementNode element = new FleetingElementNode(elementName, typeCode);
            FleetingDocumentNode parent = this.elementStackTop > 0 ? this.elementStack[this.elementStackTop - 1] : this.documentNode;
            element.setParent(parent);
            element.setLocalNamespaces(this.startTagBuffer.getLocalNamespaces());
            element.setAttributes(AttributeCollectionImpl.copy((AttributeCollectionImpl)this.startTagBuffer.getAllAttributes()));
            element.setHasChildren((properties & 0x20000) != 0);
            this.elementStack[this.elementStackTop] = element;
            this.receiverCountStack[this.elementStackTop] = 0;
            this.namespaceCountStack[this.elementStackTop++] = 0;
            ArrayList<ClosedownAction> activeWatchList = new ArrayList<ClosedownAction>(4);
            this.activeWatchStack.push(activeWatchList);
            this.addPrearrangedWatches();
            for (int i = 0; i < this.watchList.size(); ++i) {
                Watch watch = this.watchList.get(i);
                boolean matches = watch.matchesNode(element, this.context);
                if (!matches) continue;
                ClosedownAction action = new ClosedownAction(watch, 0);
                activeWatchList.add(action);
                Receiver out = watch.startSelectedParentNode(element, location);
                if (out == null) continue;
                out.open();
                this.activeReceiverStack.push(out);
                int n = this.elementStackTop - 1;
                this.receiverCountStack[n] = this.receiverCountStack[n] + 1;
            }
            int totalReceivers = this.activeReceiverStack.size();
            for (Receiver out : this.activeReceiverStack) {
                try {
                    out.startElement(elementName, typeCode, location, properties);
                }
                catch (ValidationException err) {
                    ve = err;
                }
            }
            int newReceivers = this.receiverCountStack[this.elementStackTop - 1];
            for (int i = totalReceivers - newReceivers; i < totalReceivers; ++i) {
                Receiver out = (Receiver)this.activeReceiverStack.get(i);
                for (int n = 0; n < this.namespaceStackTop; ++n) {
                    out.namespace(this.namespaceStack[n], 0);
                }
            }
            if (ve != null) {
                throw ve;
            }
            this.lastLocationId = location.saveLocation();
        }
        catch (QuitParsingException quit) {
            while (!this.activeWatchStack.isEmpty()) {
                this.endElement();
            }
            this.getPipelineConfiguration().getErrorListener().warning(quit);
            throw quit;
        }
    }

    public int getDepth() {
        return this.elementStackTop;
    }

    private void ensureStackSpace() {
        if (this.elementStackTop + 1 > this.elementStack.length) {
            this.elementStack = Arrays.copyOf(this.elementStack, this.elementStackTop * 2);
            this.receiverCountStack = Arrays.copyOf(this.receiverCountStack, this.elementStackTop * 2);
            this.namespaceCountStack = Arrays.copyOf(this.namespaceCountStack, this.elementStackTop * 2);
        }
    }

    protected void addPrearrangedWatches() throws XPathException {
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        try {
            FleetingNode att = null;
            this.trace("attribute " + nameCode.getDisplayName());
            for (Watch watch : this.watchList) {
                boolean matches;
                if (!watch.matchesNodesOfKind(UType.ATTRIBUTE)) continue;
                if (att == null) {
                    att = new FleetingNode();
                    att.setNodeKind(2);
                    att.setNodeName(nameCode);
                    att.setTypeAnnotation(typeCode);
                    att.setParent(this.elementStack[this.elementStackTop - 1]);
                    att.setStringValue(value);
                }
                if (!(matches = watch.matchesNode(att, this.context))) continue;
                watch.processItem(att);
            }
            for (Receiver out : this.activeReceiverStack) {
                out.attribute(nameCode, typeCode, value, locationId, properties);
            }
            this.lastLocationId = locationId;
        }
        catch (QuitParsingException quit) {
            while (!this.activeWatchStack.isEmpty()) {
                this.endElement();
            }
            this.getPipelineConfiguration().getErrorListener().warning(quit);
            throw quit;
        }
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        for (NamespaceBinding ns : namespaceBindings) {
            int n = this.elementStackTop - 1;
            this.namespaceCountStack[n] = this.namespaceCountStack[n] + 1;
            if (this.namespaceStackTop >= this.namespaceStack.length) {
                this.namespaceStack = Arrays.copyOf(this.namespaceStack, this.namespaceStackTop * 2);
            }
            this.namespaceStack[this.namespaceStackTop++] = ns;
        }
        for (Receiver out : this.activeReceiverStack) {
            out.namespace(namespaceBindings, properties);
        }
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        try {
            this.trace("text: " + Err.wrap(chars));
            this.ensureStackSpace();
            FleetingNode node = null;
            FleetingDocumentNode parent = this.elementStackTop > 0 ? this.elementStack[this.elementStackTop - 1] : this.documentNode;
            for (Watch watch : this.watchList) {
                boolean matches;
                if (!watch.matchesNodesOfKind(UType.TEXT)) continue;
                if (node == null) {
                    node = new FleetingNode();
                    node.setNodeKind(3);
                    node.setParent(parent);
                    node.setStringValue(chars.toString());
                    node.setTypeAnnotation(BuiltInAtomicType.UNTYPED_ATOMIC);
                }
                if (!(matches = watch.matchesNode(node, this.context))) continue;
                watch.processItem(node);
            }
            for (Receiver out : this.activeReceiverStack) {
                out.characters(chars, locationId, properties);
            }
            this.lastLocationId = locationId;
        }
        catch (QuitParsingException quit) {
            while (!this.activeWatchStack.isEmpty()) {
                this.endElement();
            }
            this.getPipelineConfiguration().getErrorListener().warning(quit);
            throw quit;
        }
    }

    @Override
    public void endElement() throws XPathException {
        this.trace("endElement");
        for (Receiver out : this.activeReceiverStack) {
            out.endElement();
        }
        --this.elementStackTop;
        this.namespaceStackTop -= this.namespaceCountStack[this.elementStackTop];
        int drop = this.receiverCountStack[this.elementStackTop];
        this.receiverCountStack[this.elementStackTop] = 0;
        for (int i = 0; i < drop; ++i) {
            Receiver out = this.activeReceiverStack.pop();
            out.close();
        }
        List<ClosedownAction> activeWatchList = this.activeWatchStack.pop();
        QuitParsingException quit = null;
        int[] doItWhen = new int[activeWatchList.size()];
        for (int i = 0; i < activeWatchList.size(); ++i) {
            ClosedownAction action = activeWatchList.get(i);
            doItWhen[i] = action.watch instanceof Trigger && ((Trigger)action.watch).getAction() instanceof SnapshotFeed ? 0 : (action.watch instanceof AccumulatorWatch ? 1 : 2);
        }
        for (int phase = 0; phase <= 2; ++phase) {
            for (int i = activeWatchList.size() - 1; i >= 0; --i) {
                ClosedownAction action = activeWatchList.get(i);
                if (doItWhen[i] != phase) continue;
                if (action.action == 0) {
                    try {
                        action.watch.endSelectedParentNode(this.lastLocationId);
                    }
                    catch (QuitParsingException q) {
                        quit = q;
                    }
                    continue;
                }
                try {
                    action.watch.close();
                }
                catch (QuitParsingException q) {
                    quit = q;
                }
                this.watchList.remove(action.watch);
            }
        }
        if (quit != null) {
            while (!this.activeWatchStack.isEmpty()) {
                this.endElement();
            }
            throw quit;
        }
    }

    @Override
    public void endDocument() throws XPathException {
        this.trace("endDocument");
        for (Receiver out : this.activeReceiverStack) {
            out.endDocument();
        }
        --this.elementStackTop;
        int drop = this.receiverCountStack[this.elementStackTop];
        this.receiverCountStack[this.elementStackTop] = 0;
        for (int i = 0; i < drop; ++i) {
            Receiver out = this.activeReceiverStack.pop();
            out.close();
        }
        List<ClosedownAction> activeWatchList = this.activeWatchStack.pop();
        for (int i = activeWatchList.size() - 1; i >= 0; --i) {
            ClosedownAction action = activeWatchList.get(i);
            if (action.action == 0) {
                action.watch.endSelectedParentNode(this.lastLocationId);
                continue;
            }
            action.watch.close();
            this.watchList.remove(action.watch);
        }
    }

    @Override
    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.ensureStackSpace();
        FleetingNode node = new FleetingNode();
        FleetingDocumentNode parent = this.elementStackTop > 0 ? this.elementStack[this.elementStackTop - 1] : this.documentNode;
        node.setNodeKind(8);
        node.setParent(parent);
        node.setStringValue(chars.toString());
        node.setTypeAnnotation(BuiltInAtomicType.UNTYPED_ATOMIC);
        if (this.startDocumentPending) {
            this.documentNode.captureInitialCommentOrProcessingInstruction(node);
        } else {
            for (Watch watch : this.watchList) {
                boolean matches = watch.matchesNode(node, this.context);
                if (!matches) continue;
                watch.processItem(node);
            }
            for (Receiver out : this.activeReceiverStack) {
                out.comment(chars, locationId, properties);
            }
            this.lastLocationId = locationId;
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        this.ensureStackSpace();
        FleetingNode node = new FleetingNode();
        FleetingDocumentNode parent = this.elementStackTop > 0 ? this.elementStack[this.elementStackTop - 1] : this.documentNode;
        node.setNodeKind(7);
        node.setParent(parent);
        NoNamespaceName nodeName = new NoNamespaceName(target);
        node.setNodeName(nodeName);
        node.setStringValue(data.toString());
        node.setTypeAnnotation(BuiltInAtomicType.UNTYPED_ATOMIC);
        if (this.startDocumentPending) {
            this.documentNode.captureInitialCommentOrProcessingInstruction(node);
        } else {
            for (Watch watch : this.watchList) {
                boolean matches = watch.matchesNode(node, this.context);
                if (!matches) continue;
                watch.processItem(node);
            }
            for (Receiver out : this.activeReceiverStack) {
                out.processingInstruction(target, data, locationId, properties);
            }
            this.lastLocationId = locationId;
        }
    }

    @Override
    public void startContent() throws XPathException {
        for (Receiver out : this.activeReceiverStack) {
            out.startContent();
        }
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
        if (this.documentNode != null) {
            this.documentNode.setUnparsedEntity(name, systemID, publicID);
        }
    }

    public void addWatch(Watch watch, boolean autoClose) throws XPathException {
        this.watchList.add(watch);
        watch.setPipelineConfiguration(this.getPipelineConfiguration());
        watch.setNamespaceResolver(this);
        boolean foundGroupCapture = false;
        if (!this.capturingScopes.isEmpty()) {
            for (GroupingScope scope : this.capturingScopes) {
                if (!scope.isActive) continue;
                scope.addWatch(watch);
                watch.setAnchorNode(this.elementStack[this.elementStackTop - 1]);
                foundGroupCapture = true;
            }
        }
        if (!foundGroupCapture && this.elementStackTop > 0) {
            watch.setAnchorNode(this.elementStack[this.elementStackTop - 1]);
            if (autoClose) {
                this.activeWatchStack.peek().add(new ClosedownAction(watch, 1));
            }
        }
        if (autoClose) {
            watch.open(Terminator.getInstance());
        }
    }

    public void removeWatch(Watch watch) {
        this.watchList.remove(watch);
    }

    @Override
    public String getURIForPrefix(String prefix, boolean useDefault) {
        if (!useDefault && prefix.isEmpty()) {
            return "";
        }
        for (int i = this.namespaceStackTop - 1; i >= 0; --i) {
            if (!this.namespaceStack[i].getPrefix().equals(prefix)) continue;
            String uri = this.namespaceStack[i].getURI();
            if (uri.isEmpty()) {
                if (prefix.isEmpty()) {
                    return "";
                }
                return null;
            }
            return uri;
        }
        return prefix.isEmpty() ? "" : null;
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        HashSet<String> declaredPrefixes = new HashSet<String>(5);
        HashSet<String> undeclaredPrefixes = new HashSet<String>(5);
        for (int i = this.namespaceStackTop - 1; i >= 0; --i) {
            String prefixCode = this.namespaceStack[i].getPrefix();
            String uriCode = this.namespaceStack[i].getURI();
            if (uriCode.isEmpty()) {
                undeclaredPrefixes.add(prefixCode);
                continue;
            }
            if (undeclaredPrefixes.contains(prefixCode)) continue;
            declaredPrefixes.add(this.namespaceStack[i].getPrefix());
        }
        return declaredPrefixes.iterator();
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }

    public FleetingDocumentNode getDocumentNode() {
        return this.documentNode;
    }

    public Map<Accumulator, AccumulatorWatch> getAccumulatorWatchMap() {
        return this.accumulatorWatchMap;
    }

    public void setAccumulatorWatchMap(Map<Accumulator, AccumulatorWatch> accumulatorWatchMap) {
        this.accumulatorWatchMap = accumulatorWatchMap;
    }

    public GroupingScope startGroupingScope() {
        return new GroupingScope();
    }

    public void endGroupingScope(GroupingScope current) throws XPathException {
        for (Watch watch : current.watches) {
            watch.close();
            this.removeWatch(watch);
        }
    }

    public void startCapturingGroupingWatches(GroupingScope scope) {
        this.capturingScopes.add(scope);
    }

    public void stopCapturingGroupingWatches(GroupingScope scope) {
        this.capturingScopes.remove(scope);
    }

    private static class ClosedownAction {
        public static final int DEACTIVATE = 0;
        public static final int CLOSE = 1;
        public Watch watch;
        public int action;

        public ClosedownAction(Watch watch, int action) {
            this.watch = watch;
            this.action = action;
        }
    }

    public static class GroupingScope {
        public boolean isActive = true;
        public List<Watch> watches = new ArrayList<Watch>();

        private void addWatch(Watch watch) {
            if (this.isActive) {
                this.watches.add(watch);
            }
        }
    }
}

