/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.StringReader;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.IgnorableSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.value.AtomicValue;
import org.xml.sax.InputSource;

public class Parse
extends SystemFunction {
    public NodeInfo call(XPathContext context, Sequence[] arguments) throws XPathException {
        Controller controller = context.getController();
        Configuration config = controller.getConfiguration();
        AtomicValue content = (AtomicValue)arguments[0].head();
        StringReader sr = new StringReader(content.getStringValue());
        InputSource is = new InputSource(sr);
        is.setSystemId(this.getStaticBaseUriString());
        SAXSource source = new SAXSource(is);
        source.setSystemId(this.getStaticBaseUriString());
        Builder b = controller.makeBuilder();
        if (b instanceof TinyBuilder) {
            ((TinyBuilder)b).setStatistics(config.getTreeStatistics().FN_PARSE_STATISTICS);
        }
        Receiver s = b;
        ParseOptions options = new ParseOptions();
        PackageData pd = this.getRetainedStaticContext().getPackageData();
        if (pd instanceof StylesheetPackage) {
            options.setSpaceStrippingRule(((StylesheetPackage)pd).getSpaceStrippingRule());
            if (((StylesheetPackage)pd).isStripsTypeAnnotations()) {
                s = config.getAnnotationStripper(s);
            }
        } else {
            options.setSpaceStrippingRule(IgnorableSpaceStrippingRule.getInstance());
        }
        options.setErrorListener(context.getConfiguration().getErrorListener());
        this.setXMLReader(config, options);
        s.setPipelineConfiguration(b.getPipelineConfiguration());
        Sender.send(source, s, options);
        NodeInfo node = b.getCurrentRoot();
        b.reset();
        return node;
    }

    protected void setXMLReader(Configuration config, ParseOptions source) throws XPathException {
    }
}

