/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.InspectionAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.GroundedItemFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;

public class InstanceOfAdjunct
extends InspectionAdjunct
implements FeedMaker {
    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return new InstanceOfFeed(watchManager, this.getExpression(), out, context);
    }

    private static class InstanceOfFeed
    extends GroundedItemFeed {
        WatchManager watchManager;
        ItemType itemType;
        int level;
        int count;
        int cardinality;
        boolean matchesSoFar;
        boolean closed;

        InstanceOfFeed(WatchManager watchManager, Expression exp, ItemFeed result, XPathContext context) {
            super(exp, result, context);
            this.watchManager = watchManager;
            this.itemType = ((InstanceOfExpression)exp).getRequiredItemType();
            this.cardinality = ((InstanceOfExpression)exp).getRequiredCardinality();
            this.matchesSoFar = true;
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            this.count = 0;
            this.level = 0;
            this.matchesSoFar = true;
        }

        @Override
        public void append(Item item) throws XPathException {
            if (this.level == 0 && this.matchesSoFar) {
                if (!this.itemType.matches(item, this.getContext().getConfiguration().getTypeHierarchy())) {
                    this.matchesSoFar = false;
                }
                ++this.count;
                if (this.count == 2 && !Cardinality.allowsMany(this.cardinality)) {
                    this.matchesSoFar = false;
                }
                if (!this.matchesSoFar) {
                    this.getNextOutputter().append(BooleanValue.FALSE);
                    if (this.watchManager.allowsEarlyExit()) {
                        this.closed = true;
                        this.getNextOutputter().close();
                        this.getTerminator().terminate();
                    }
                }
            }
        }

        @Override
        public void close() throws XPathException {
            if (this.matchesSoFar) {
                if (this.count == 0 && !Cardinality.allowsZero(this.cardinality)) {
                    this.matchesSoFar = false;
                }
                this.getNextOutputter().append(BooleanValue.get(this.matchesSoFar));
            }
            if (!this.closed) {
                this.getNextOutputter().close();
            }
        }

        @Override
        public void startDocument(int properties) throws XPathException {
            if (this.level == 0) {
                Orphan orphan = new Orphan(this.getConfiguration());
                orphan.setNodeKind((short)9);
                this.append(orphan);
            }
            ++this.level;
        }

        @Override
        public void endDocument() throws XPathException {
            --this.level;
        }

        @Override
        public void startElement(NodeName elemName, SchemaType type, Location location, int properties) throws XPathException {
            if (this.level == 0 && this.matchesSoFar) {
                Orphan orphan = new Orphan(this.getConfiguration());
                orphan.setNodeKind((short)1);
                orphan.setNodeName(elemName);
                orphan.setTypeAnnotation(type);
                orphan.setStringValue(EmptyUnicodeString.getInstance());
                this.append(orphan);
            }
            ++this.level;
        }

        @Override
        public void namespace(String prefix, NamespaceUri namespaceUri, int properties) throws XPathException {
            if (this.level == 0) {
                super.namespace(prefix, namespaceUri, properties);
            }
        }

        @Override
        public void attribute(NodeName attName, SimpleType typeCode, String value, Location location, int properties) throws XPathException {
            if (this.level == 0) {
                super.attribute(attName, typeCode, value, location, properties);
            }
        }

        @Override
        public void endElement() throws XPathException {
            --this.level;
        }

        @Override
        public void characters(UnicodeString chars, Location location, int properties) throws XPathException {
            if (this.level == 0) {
                super.characters(chars, location, properties);
            }
        }

        @Override
        public void processingInstruction(String name, UnicodeString data, Location location, int properties) throws XPathException {
            if (this.level == 0) {
                super.processingInstruction(name, data, location, properties);
            }
        }

        @Override
        public void comment(UnicodeString content, Location location, int properties) throws XPathException {
            if (this.level == 0) {
                super.comment(content, location, properties);
            }
        }

        @Override
        public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
            this.startElement(elemName, type, location, properties);
        }
    }
}

