/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.response.match;

import de.ids_mannheim.korap.response.match.DocIdentifier;
import de.ids_mannheim.korap.util.KrillProperties;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchIdentifier
extends DocIdentifier {
    private int startPos;
    private int endPos = -1;
    private static final Logger log = LoggerFactory.getLogger(MatchIdentifier.class);
    private ArrayList<int[]> pos = new ArrayList(8);
    String idRegexPos = "(p([0-9]+)-([0-9]+)((?:\\(-?[0-9]+\\)-?[0-9]+--?[0-9]+)*)(?:c.+?)?)";
    Pattern idRegex = Pattern.compile("^(?:match-|contains-)(?:([^!]+?)[!\\.])?([^!]+)[-/]" + this.idRegexPos + "(?:x_([a-zA-Z0-9-_]+?))?$");
    Pattern posRegex = Pattern.compile("\\(([0-9]+)\\)([0-9]+)-([0-9]+)");
    private static volatile Mac mac = null;

    public MatchIdentifier() {
        if (mac == null) {
            Properties prop = KrillProperties.loadDefaultProperties();
            String secretKey = KrillProperties.secret;
            MatchIdentifier.initMac(secretKey);
        }
    }

    public MatchIdentifier(String id) {
        Matcher matcher;
        if (mac == null) {
            Properties prop = KrillProperties.loadDefaultProperties();
            String secretKey = KrillProperties.secret;
            MatchIdentifier.initMac(secretKey);
        }
        if ((matcher = this.idRegex.matcher(id = id.replaceAll("^(contains-|match-)([^!_\\.]+?)!\\2_", "$1$2_"))).matches()) {
            if (matcher.group(1) == null && id.contains("/")) {
                this.setTextSigle(matcher.group(2));
            } else if (id.contains("!") || !id.contains("_")) {
                this.setCorpusID(matcher.group(1));
                this.setDocID(matcher.group(2));
            } else {
                this.setTextSigle(matcher.group(1) + "." + matcher.group(2));
            }
            if (mac != null) {
                byte[] hmacVerify;
                String posString = matcher.group(3);
                String message = this.getTextSigle() + "::" + posString;
                String hmacStr = matcher.group(7);
                if (hmacStr == null) {
                    this.textSigle = "";
                    return;
                }
                byte[] hmacBytes = Base64.getUrlDecoder().decode(hmacStr);
                if (!MessageDigest.isEqual(hmacBytes, hmacVerify = mac.doFinal(message.getBytes(StandardCharsets.UTF_8)))) {
                    this.textSigle = "";
                    return;
                }
            }
            this.setStartPos(Integer.parseInt(matcher.group(4)));
            this.setEndPos(Integer.parseInt(matcher.group(5)));
            if (matcher.group(6) != null) {
                matcher = this.posRegex.matcher(matcher.group(6));
                while (matcher.find()) {
                    this.addPos(Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(1)));
                }
            }
        }
    }

    public int getStartPos() {
        return this.startPos;
    }

    public void setStartPos(int pos) {
        if (pos >= 0) {
            this.startPos = pos;
        }
    }

    public int getEndPos() {
        return this.endPos;
    }

    public void setEndPos(int pos) {
        if (pos >= 0) {
            this.endPos = pos;
        }
    }

    public void addPos(int start, int end, int number) {
        if (start >= 0 && end >= 0 && number >= 0) {
            this.pos.add(new int[]{start, end, number});
        }
    }

    public ArrayList<int[]> getPos() {
        return this.pos;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("match-");
        if (this.docID == null) {
            if (this.textSigle == null) {
                return null;
            }
            sb.append(this.textSigle);
        } else if (this.corpusID != null) {
            sb.append(this.corpusID).append('!').append(this.docID);
        } else {
            sb.append(this.docID);
        }
        sb.append('-');
        sb.append(this.getPositionString());
        if (mac != null) {
            String message = this.getTextSigle() + "::" + this.getPositionString();
            byte[] hmac = mac.doFinal(message.getBytes(StandardCharsets.UTF_8));
            String hmacStr = Base64.getUrlEncoder().withoutPadding().encodeToString(hmac);
            sb.append("x_").append(hmacStr);
        }
        return sb.toString();
    }

    public String getPositionString() {
        StringBuilder sb = new StringBuilder();
        sb.append('p').append(this.startPos).append('-').append(this.endPos);
        for (int[] i : this.pos) {
            sb.append('(').append(i[2]).append(')');
            sb.append(i[0]).append('-').append(i[1]);
        }
        return sb.toString();
    }

    public static void initMac(String secretKey) {
        if (secretKey != "") {
            try {
                mac = Mac.getInstance("HmacSHA256");
                SecretKeySpec keySpec = new SecretKeySpec(secretKey.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
                mac.init(keySpec);
            }
            catch (Exception e) {
                log.error("Can't initialize match id signing: {}", e);
            }
        } else {
            mac = null;
        }
    }
}

