/*
 * Decompiled with CFR 0.152.
 */
package experimental.analyzer.simple;

import experimental.analyzer.AnalyzerInstance;
import experimental.analyzer.simple.SimpleAnalyzer;
import experimental.analyzer.simple.SimpleAnalyzerInstance;
import experimental.analyzer.simple.SimpleAnalyzerModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import marmot.util.Numerics;

public class SimpleEvaluator {
    public void eval(SimpleAnalyzer analyzer, Collection<AnalyzerInstance> in_instances, List<Double> ambiguities) {
        Iterator<Number> iterator2;
        LinkedList<AnalyzerInstance> instances = new LinkedList<AnalyzerInstance>();
        for (AnalyzerInstance instance : instances) {
            if (!analyzer.isUnknown(instance)) continue;
            instances.add(instance);
        }
        SimpleAnalyzerModel model = analyzer.getModel();
        SimpleAnalyzer.Mode mode = analyzer.getMode();
        int num_tags = model.getNumTags();
        LinkedList entries = new LinkedList();
        for (AnalyzerInstance instance : instances) {
            SimpleAnalyzerInstance simple_instance = model.getInstance(instance);
            double[] scores = new double[num_tags];
            model.score(simple_instance, scores);
            double sum = Double.NEGATIVE_INFINITY;
            if (mode == SimpleAnalyzer.Mode.classifier) {
                for (double score : scores) {
                    sum = Numerics.sumLogProb(score, sum);
                }
            }
            int num_readings = simple_instance.getTagIndexes().size();
            ArrayList<Entry> current_entries = new ArrayList<Entry>(num_tags);
            for (int tag_index = 0; tag_index < num_tags; ++tag_index) {
                Entry entry = new Entry();
                entry.active = false;
                entry.prob = mode == SimpleAnalyzer.Mode.classifier ? Math.exp(scores[tag_index] - sum) : Math.exp(scores[tag_index] - Numerics.sumLogProb(scores[tag_index], 0.0));
                assert (entry.prob >= 0.0 && entry.prob < 1.0);
                entry.num_tags = num_readings;
                current_entries.add(entry);
            }
            iterator2 = simple_instance.getTagIndexes().iterator();
            while (iterator2.hasNext()) {
                int tag_index = (Integer)iterator2.next();
                ((Entry)current_entries.get((int)tag_index)).active = true;
            }
            entries.addAll(current_entries);
        }
        Collections.sort(entries);
        double current_coverage = 0.0;
        double current_ambiguity = 0.0;
        for (Entry entry : entries) {
            if (entry.active) {
                current_coverage += 1.0 / (double)(entry.num_tags * instances.size());
            }
            double prev_ambiguity = current_ambiguity;
            current_ambiguity += 1.0 / (double)instances.size();
            iterator2 = ambiguities.iterator();
            while (iterator2.hasNext()) {
                double ambiguity_value = iterator2.next();
                if (!(prev_ambiguity <= ambiguity_value) || !(current_ambiguity >= ambiguity_value)) continue;
                System.err.format("Amb: %g Cov: %g (Th: %g)\n", current_ambiguity, current_coverage, entry.prob);
            }
        }
    }

    private static class Entry
    implements Comparable<Entry> {
        double prob;
        boolean active;
        int num_tags;

        private Entry() {
        }

        @Override
        public int compareTo(Entry o) {
            return -Double.compare(this.prob, o.prob);
        }
    }
}

