/*
 * Decompiled with CFR 0.152.
 */
package experimental.morfessor;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Morpheme {
    public static final String NON_MORPHEME = "ZZZ";
    public static final String STEM = "STM";
    private String morpheme_;
    private String asterisk_;
    private String tag_;
    private static final Pattern MORPHEME_ASTERISK_TAG_PATTERN_ = Pattern.compile("^([^*]*)(\\*[0-4])?(/[A-Z]*)$");

    public Morpheme(String morpheme, String asterisk, String tag) {
        this.morpheme_ = morpheme;
        this.asterisk_ = asterisk;
        this.tag_ = tag;
    }

    public Morpheme(String morpheme_asterisk_tag) {
        Matcher m4 = MORPHEME_ASTERISK_TAG_PATTERN_.matcher(morpheme_asterisk_tag);
        if (!m4.matches()) {
            throw new InvalidParameterException();
        }
        this.morpheme_ = m4.group(1);
        this.asterisk_ = m4.group(2);
        if (this.asterisk_ != null) {
            this.asterisk_ = new String(this.asterisk_.substring(1));
        }
        this.tag_ = new String(m4.group(3).substring(1));
    }

    public static String join(List<Morpheme> morphemes, boolean with_asterisk, boolean with_tag, String seperator) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (Morpheme morph : morphemes) {
            sb.append(morph.toString(with_asterisk, with_tag));
            if (index < morphemes.size() - 1) {
                sb.append(seperator);
            }
            ++index;
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(true, true);
    }

    public String toString(boolean with_asterisk, boolean with_tag) {
        StringBuilder sb = new StringBuilder(this.morpheme_);
        if (with_asterisk && this.asterisk_ != null) {
            sb.append("*" + this.asterisk_);
        }
        if (with_tag) {
            sb.append("/" + this.tag_);
        }
        return sb.toString();
    }

    public static List<Morpheme> split(String morphemes) {
        String[] tokens = morphemes.split(" \\+ ");
        ArrayList<Morpheme> morpheme_list = new ArrayList<Morpheme>(tokens.length);
        for (String token : tokens) {
            morpheme_list.add(new Morpheme(token));
        }
        return morpheme_list;
    }

    public String getTag() {
        return this.tag_;
    }

    public String getMorphAsterisk() {
        return this.toString(true, false);
    }

    public boolean isNonMorpheme() {
        return this.tag_.equals(NON_MORPHEME);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Morpheme)) {
            return false;
        }
        Morpheme morph = (Morpheme)other;
        if (!morph.morpheme_.equals(this.morpheme_)) {
            return false;
        }
        return morph.tag_.equals(this.tag_);
    }

    public void setTag(String tag) {
        this.tag_ = tag;
    }

    public String getMorpheme() {
        return this.morpheme_;
    }

    public void setMorpheme(String morpheme) {
        this.morpheme_ = morpheme;
    }

    public void setAsterisk(String asterisk) {
        this.asterisk_ = asterisk;
    }
}

