/*
 * Decompiled with CFR 0.152.
 */
package marmot.tokenize.openlp;

import java.io.Writer;
import java.util.List;
import marmot.tokenize.openlp.Aligner;
import marmot.tokenize.openlp.LevenshteinAligner;
import marmot.tokenize.preprocess.Pair;
import marmot.tokenize.rules.RuleProvider;
import marmot.tokenize.rules.RulebasedTransformator;

public class OpenNlpConverter {
    private RulebasedTransformator untok_transformator_;
    private RulebasedTransformator tok_transformator_;

    public OpenNlpConverter(RuleProvider provider) {
        if (provider == null) {
            this.tok_transformator_ = null;
            this.untok_transformator_ = null;
        } else {
            this.tok_transformator_ = provider.getTokTransformator();
            this.untok_transformator_ = provider.getUnTokTransformator();
        }
    }

    public void convert(Iterable<Pair> pairs, Writer writer, int verbose) {
        LevenshteinAligner a = new LevenshteinAligner();
        int total = 0;
        int error = 0;
        for (Pair pair : pairs) {
            ++total;
            String tokenized = pair.tokenized;
            String untokenized = pair.untokenized;
            if (this.tok_transformator_ != null) {
                tokenized = this.tok_transformator_.applyRules(tokenized);
            }
            if (this.untok_transformator_ != null) {
                untokenized = this.untok_transformator_.applyRules(untokenized);
            }
            try {
                List<Aligner.Pair> alignment = a.align((String)tokenized, (String)untokenized).pairs;
                if (alignment == null) {
                    throw new RuntimeException();
                }
                writer.write(this.insertSplit(untokenized, alignment));
                writer.write("\n");
            }
            catch (Exception e) {
                ++error;
                if (verbose != 2 && verbose != 3) continue;
                if (!e.getClass().toString().split("\\.")[2].equals("RuntimeException")) {
                    System.err.println("GRAVE ERROR!");
                }
                System.err.println("<Tok> " + tokenized + "</Tok>");
                System.err.println("<UnT> " + untokenized + "</UnT>");
            }
        }
        if (verbose > 0) {
            System.err.format("Conversion Error rate: %d / %d = %g\n", error, total, (double)error * 100.0 / (double)total);
        }
    }

    private String insertSplit(String untokenized, List<Aligner.Pair> alignment) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (Aligner.Pair p : alignment) {
            if (p.b == -1) {
                sb.append("<SPLIT>");
                continue;
            }
            sb.append(untokenized.charAt(index));
            ++index;
        }
        return sb.toString();
    }
}

