/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.z.IntHashMap;

public class Verifier {
    private static final boolean DISABLED = false;
    private static final int MS_A_DAY = 86400000;
    private License primaryLicense = null;
    private IntHashMap<License> secondaryLicenses = new IntHashMap();
    protected int status = 0;
    public static final int UNREAD = 0;
    public static final int AVAILABLE = 1;
    public static final int UNAVAILABLE = 2;
    public static final String LICENSE_FILE_NAME = "saxon-license.lic";
    private static final String PUBLIC_KEY = "308201B73082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A038184000281806CA067E469754A2F98D08965D35AB41252974F69FCD260152CFB58F94D8B956D6A1A91CC213A11107301DD37C85B383DDA409EC067D2A8C4BE6651020A69AFD533630172D6F96F928667D7705D46E56D364E8E967002A7D864BACB02225F52B271BA1F6522D98FF8299C6273B24BC41202C8857897E46B40FD7624A9CB0CC9E8";
    private static byte[] key = Verifier.convertHexToBinary("308201B73082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A038184000281806CA067E469754A2F98D08965D35AB41252974F69FCD260152CFB58F94D8B956D6A1A91CC213A11107301DD37C85B383DDA409EC067D2A8C4BE6651020A69AFD533630172D6F96F928667D7705D46E56D364E8E967002A7D864BACB02225F52B271BA1F6522D98FF8299C6273B24BC41202C8857897E46B40FD7624A9CB0CC9E8");

    public void displayLicenseMessage(Configuration config) {
        this.loadPrimaryLicense(config);
        if (config.isTiming()) {
            config.getStandardErrorOutput().println("Using license serial number " + this.getSerialNumber());
        }
        if (!config.getConfigurationProperty(Feature.SUPPRESS_EVALUATION_EXPIRY_WARNING).booleanValue()) {
            int left = this.primaryLicense.daysLeft();
            if (left == 1) {
                config.getStandardErrorOutput().println("****** Saxon evaluation license expires tomorrow! ******");
            } else if (left > 0 && left < 15) {
                config.getStandardErrorOutput().println("Saxon evaluation license expires in " + left + " days");
            }
        }
    }

    public String getFeature(String name, Configuration config) {
        this.loadPrimaryLicense(config);
        return this.primaryLicense.getFeature(name);
    }

    protected final void loadPrimaryLicense(Configuration config) {
        if (this.status == 2) {
            throw new LicenseException("Saxon license disabled", 3);
        }
        if (this.status == 0) {
            try {
                this.primaryLicense = this.loadLicense(config);
                this.status = 1;
            }
            catch (LicenseException e) {
                this.primaryLicense = null;
                this.status = 2;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final License loadLicense(Configuration config) {
        InputStream is = null;
        try {
            ArrayList<String> attempts = new ArrayList<String>(4);
            is = this.lookInCodeLocation(is, attempts);
            if (is == null) {
                is = Verifier.lookInInstallationDirectory(config, is, attempts);
            }
            if (is == null) {
                is = Verifier.lookInClassPath(is);
            }
            if (is == null) {
                attempts.add("classpath");
                String message = "License file saxon-license.lic not found. Tried in ";
                for (int i = 0; i < attempts.size(); ++i) {
                    message = message + (String)attempts.get(i);
                    if (i < attempts.size() - 2) {
                        message = message + ", ";
                        continue;
                    }
                    if (i != attempts.size() - 2) continue;
                    message = message + ", and ";
                }
                throw new LicenseException(message, 3);
            }
            License license = this.readLicenseFile(is);
            return license;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static InputStream lookInClassPath(InputStream is) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        is = cl.getResourceAsStream(LICENSE_FILE_NAME);
        return is;
    }

    private static InputStream lookInInstallationDirectory(Configuration config, InputStream is, List<String> attempts) {
        String home = Version.platform.getInstallationDirectory(Version.softwareEdition, config);
        if (home != null) {
            String path = home.endsWith("/") || home.endsWith("\\") ? home + "bin/" + LICENSE_FILE_NAME : home + "/bin/" + LICENSE_FILE_NAME;
            attempts.add(path);
            try {
                is = new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                path = home.endsWith("/") || home.endsWith("\\") ? home + LICENSE_FILE_NAME : home + "/" + LICENSE_FILE_NAME;
                attempts.add(path);
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        return is;
    }

    private InputStream lookInCodeLocation(InputStream is, List<String> attempts) {
        try {
            URL sourceLoc;
            CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
            if (codeSource != null && (sourceLoc = codeSource.getLocation()) != null) {
                URL licenseLoc = new URL(sourceLoc, LICENSE_FILE_NAME);
                attempts.add(licenseLoc.toString());
                is = licenseLoc.openStream();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return is;
    }

    public synchronized void loadLicense(String filename) {
        boolean exists = false;
        try {
            InputStream is;
            if (filename.startsWith("file:")) {
                is = new URL(filename).openStream();
            } else {
                exists = new File(filename).exists();
                is = new FileInputStream(filename);
            }
            this.primaryLicense = this.readLicenseFile(is);
            this.status = 1;
            is.close();
        }
        catch (IOException e) {
            this.primaryLicense = null;
            this.status = 2;
            throw new LicenseException("Failed to read license file " + filename, exists ? 3 : 5);
        }
    }

    public synchronized int registerSecondaryLicense(String dmk) {
        try {
            Base64BinaryValue b64 = new Base64BinaryValue(dmk);
            byte[] binary = b64.getBinaryValue();
            ByteArrayInputStream is = new ByteArrayInputStream(binary);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "utf8"));
            License license = Verifier.configure(reader, true);
            int id = dmk.hashCode() & 0x3FFFF;
            while (this.secondaryLicenses.get(id) != null) {
                ++id;
            }
            this.secondaryLicenses.put(id, license);
            return id;
        }
        catch (XPathException err) {
            throw new LicenseException(err.getMessage(), 2);
        }
        catch (IOException err) {
            throw new LicenseException(err.getMessage(), 2);
        }
    }

    public void disableLicensing() {
        this.primaryLicense = null;
        this.status = 2;
    }

    public synchronized boolean isFeatureAllowedBySecondaryLicense(int license, int feature) {
        License lic = this.secondaryLicenses.get(license);
        if (lic == null) {
            return false;
        }
        switch (feature) {
            case 8: {
                return true;
            }
            case 2: {
                return "yes".equals(lic.getFeature("SAT"));
            }
            case 4: {
                return "yes".equals(lic.getFeature("SAQ"));
            }
            case 1: {
                return "yes".equals(lic.getFeature("SAV"));
            }
        }
        return false;
    }

    private License readLicenseFile(InputStream is) {
        BufferedReader reader;
        try {
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new LicenseException("License file uses UTF-8, which is an unsupported encoding", 2);
        }
        return Verifier.configure(reader, false);
    }

    public synchronized void supplyLicenseKey(BufferedReader reader) {
        License license = Verifier.configure(reader, false);
        String value = license.getFeature("Company");
        if (value == null || !value.startsWith("OEM")) {
            this.primaryLicense = null;
            this.status = 2;
            throw new IllegalArgumentException("License key supplied is not a valid OEM license key");
        }
        this.primaryLicense = license;
        this.status = 1;
    }

    private static License configure(BufferedReader reader, boolean embedded) {
        License license;
        try {
            DayTimeDurationValue sinceMinorRelease;
            DayTimeDurationValue sinceMajorRelease;
            String licenseDesc;
            String line;
            StringBuilder buffer = new StringBuilder(80);
            Properties features = new Properties();
            license = new License(features);
            String signature = "";
            while ((line = reader.readLine()) != null) {
                String value;
                String name;
                if (line.trim().indexOf(35) == 0 || line.trim().indexOf(33) == 0) continue;
                int index = line.indexOf(61);
                if (index > 0) {
                    name = line.substring(0, index).trim();
                    value = line.substring(++index).trim();
                } else {
                    name = line.trim();
                    value = "";
                }
                if ("".equals(name)) continue;
                features.setProperty(name, value);
                if ("Signature".equals(name)) {
                    signature = value;
                    continue;
                }
                buffer.append(name).append('=').append(value).append('\n');
            }
            boolean valid = Verifier.verify(buffer.toString(), Verifier.convertHexToBinary(signature), key);
            String string = licenseDesc = embedded ? "license embedded in the stylesheet export file" : "license file";
            if (!valid) {
                throw new LicenseException("Invalid " + licenseDesc + " found", 2);
            }
            String serial = license.getFeature("Serial");
            licenseDesc = licenseDesc + " (serial number " + serial + ")";
            if (license.daysLeft() < 0) {
                license.clearFeatures();
                throw new LicenseException("The " + licenseDesc + " has expired", 1);
            }
            DateValue licenseIssued = new DateValue(features.getProperty("Issued").substring(0, 10) + 'Z');
            DateValue majorVersionIssued = new DateValue(Version.getMajorReleaseDate() + 'Z');
            String upgradeDays = features.getProperty("UpgradeDays");
            int udays = 366;
            if (upgradeDays != null) {
                udays = Integer.parseInt(upgradeDays.trim());
            }
            if ((sinceMajorRelease = majorVersionIssued.subtract(licenseIssued, null)).getLengthInSeconds() > (double)(86400 * udays)) {
                throw new LicenseException("The " + licenseDesc + " does not cover upgrade to this Saxon version", 1);
            }
            DateValue minorVersionIssued = new DateValue(Version.getReleaseDate() + 'Z');
            String maintenanceDays = features.getProperty("MaintenanceDays");
            int mdays = udays;
            if (maintenanceDays != null) {
                mdays = Integer.parseInt(maintenanceDays.trim());
            }
            if ((sinceMinorRelease = minorVersionIssued.subtract(licenseIssued, null)).getLengthInSeconds() > (double)(86400 * mdays)) {
                throw new LicenseException("The " + licenseDesc + " does not cover this Saxon maintenance release", 1);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new LicenseException("License file uses windows-1252, which is an unsupported encoding", 2);
        }
        catch (IOException e) {
            throw new LicenseException(e.getMessage(), 3);
        }
        catch (GeneralSecurityException e) {
            throw new LicenseException(e.getMessage(), 2);
        }
        catch (XPathException e) {
            throw new LicenseException("Invalid date in license file", 2);
        }
        return license;
    }

    public String getSerialNumber() {
        return this.primaryLicense.getFeature("Serial");
    }

    private static byte[] convertHexToBinary(String hex) {
        int len = hex.length() / 2;
        byte[] out = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c1 = hex.charAt(i * 2);
            char c2 = hex.charAt(i * 2 + 1);
            if (c1 >= '0' && c1 <= '9') {
                out[i] = (byte)((c1 - 48) * 16);
            } else if (c1 >= 'A' && c1 <= 'F') {
                out[i] = (byte)((c1 - 65 + 10) * 16);
            } else {
                throw new IllegalArgumentException();
            }
            if (c2 >= '0' && c2 <= '9') {
                int n = i;
                out[n] = (byte)(out[n] + (c2 - 48));
                continue;
            }
            if (c2 >= 'A' && c2 <= 'F') {
                int n = i;
                out[n] = (byte)(out[n] + (c2 - 65 + 10));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return out;
    }

    private static boolean verify(String data, byte[] signature, byte[] encodedPublicKey) throws GeneralSecurityException, UnsupportedEncodingException {
        Signature sig = Signature.getInstance("DSA");
        PublicKey key = KeyFactory.getInstance("DSA").generatePublic(new X509EncodedKeySpec(encodedPublicKey));
        sig.initVerify(key);
        sig.update(data.getBytes(StandardCharsets.UTF_8));
        return sig.verify(signature);
    }

    public static void main(String[] args) throws Exception {
        File licenseFile = new File(args[0]);
        Verifier v = new Verifier();
        License license = v.readLicenseFile(new FileInputStream(licenseFile));
        System.err.println("License OK");
        Enumeration<?> en = license.features.propertyNames();
        while (en.hasMoreElements()) {
            String s = (String)en.nextElement();
            System.err.println("Feature " + s + " = " + license.features.getProperty(s));
        }
    }

    private static class License {
        private Properties features;

        private License(Properties features) {
            this.features = features;
        }

        protected int daysLeft() {
            String expiration = this.features.getProperty("Expiration");
            if (expiration == null) {
                return -1;
            }
            if (expiration.trim().isEmpty() || expiration.contains("never")) {
                return 0;
            }
            try {
                String evaluating = this.features.getProperty("Evaluation");
                DateValue expiryDate = new DateValue(expiration);
                long expiryTimeMillis = expiryDate.getCalendar().getTime().getTime();
                long time = expiryTimeMillis - System.currentTimeMillis();
                if ("yes".equals(evaluating) && time / 300000L % 151L == 0L) {
                    this.clearFeatures();
                    throw new LicenseException("Evaluation license temporarily suspended: please try again later", 1);
                }
                return 1 + (int)(time / 86400000L);
            }
            catch (XPathException err) {
                this.clearFeatures();
                throw new LicenseException("Invalid expiry date found in license (serial " + this.getFeature("Serial") + ")", 2);
            }
        }

        public synchronized String getFeature(String name) {
            return this.features.getProperty(name);
        }

        private void clearFeatures() {
            if (this.features != null) {
                this.features.clear();
            }
        }
    }
}

