/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;

public class LetExpressionAdjunct
extends StreamingAdjunct {
    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        Expression select = ((LetExpression)this.getExpression()).getSequence();
        final Expression action = ((LetExpression)this.getExpression()).getAction();
        if (Streamability.getSweep(select) == Sweep.CONSUMING) {
            Inversion ie = Inversion.invertExpression(select, forGrouping);
            final Inversion route = ie.copy();
            Inversion.PushAction letAction = new Inversion.PushAction();
            letAction.feedMaker = new FeedMaker(){

                @Override
                public Feed makeItemFeed(final WatchManager watchManager, final Feed out, XPathContext context) throws XPathException {
                    return new ItemFeed(LetExpressionAdjunct.this.getExpression(), out, context){
                        private SequenceOutputter writer;

                        @Override
                        public void open(Terminator terminator) throws XPathException {
                            super.open(terminator);
                            this.writer = new SequenceOutputter(watchManager.getPipelineConfiguration());
                        }

                        @Override
                        public void processItem(Item<?> item) throws XPathException {
                            this.writer.append(item);
                        }

                        @Override
                        public void close() throws XPathException {
                            Sequence<?> value = this.writer.getSequence();
                            XPathContext context = this.getContext();
                            context.setReceiver(out.getReceiver());
                            context.setLocalVariable(((LetExpression)this.getExpression()).getLocalSlotNumber(), value);
                            action.process(context);
                            super.close();
                        }

                        @Override
                        public SequenceReceiver getReceiver() {
                            return this.writer;
                        }
                    };
                }
            };
            letAction.pushMethod = 16;
            letAction.streamingChildSequence = 0;
            route.prepend(letAction);
            return new WatchMaker(){

                @Override
                public Trigger makeWatch(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
                    return route.getWatch(watchManager, out, context);
                }
            };
        }
        StreamingAdjunct sa = StreamingAdjunct.makeStreamingAdjunct(this.getConfiguration(), this.getExpression());
        return sa.getWatchMaker(forGrouping);
    }

    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        LetExpression expr = (LetExpression)this.getExpression();
        if (expr.getSequence() instanceof ContextItemExpression && contextInfo.getContextItemPosture() != Posture.GROUNDED && !this.hasNonInspectionUsage(expr, expr.getAction())) {
            expr.getSequenceOp().setUsage(OperandUsage.INSPECTION);
        }
        return super.computeStreamability(contextInfo, reasons);
    }

    private boolean hasNonInspectionUsage(LetExpression binding, Expression child) {
        for (Operand o : child.operands()) {
            if (o.getChildExpression() instanceof VariableReference) {
                if (((VariableReference)o.getChildExpression()).getBinding() == binding && o.getUsage() != OperandUsage.INSPECTION) {
                    return true;
                }
                if (!this.hasNonInspectionUsage(binding, o.getChildExpression())) continue;
                return true;
            }
            if (!this.hasNonInspectionUsage(binding, o.getChildExpression())) continue;
            return true;
        }
        return false;
    }
}

