/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.ComponentReference;
import com.saxonica.ee.schema.IdentityConstraint;
import com.saxonica.ee.schema.MissingComponentExceptionImpl;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;

public class KeyRef
extends IdentityConstraint
implements ComponentReference {
    private StructuredQName targetQName;
    private IdentityConstraint target;
    private boolean dangling = false;

    public KeyRef() {
    }

    public KeyRef(EnterpriseConfiguration config, StructuredQName refer) {
        this.setConfiguration(config);
        this.setTargetComponentName(refer);
    }

    @Override
    public String getConstraintCategory() {
        return "keyref";
    }

    @Override
    public StructuredQName getTargetComponentName() {
        return this.targetQName;
    }

    public void setTargetComponentName(StructuredQName target) {
        this.targetQName = target;
    }

    public void setTargetKey(IdentityConstraint key) {
        this.target = key;
    }

    @Override
    public void tryToResolve(SchemaCompiler compiler) {
        if (!this.dangling) {
            this.target = compiler.getPreparedSchema().getIdentityConstraint(this.getTargetComponentName());
            if (this.target == null) {
                this.target = compiler.getConfiguration().getSuperSchema().getIdentityConstraint(this.getTargetComponentName());
            }
            if (this.target == null) {
                this.dangling = true;
            }
        }
    }

    @Override
    public boolean isResolved() {
        return this.target != null;
    }

    @Override
    public boolean isDangling() {
        return this.dangling;
    }

    @Override
    public SchemaComponent getTarget() throws MissingComponentException {
        if (this.target == null) {
            throw new MissingComponentExceptionImpl(this);
        }
        return this.target;
    }

    @Override
    public int getSymbolSpace() {
        return 807;
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        if (this.getFixupStatus() == SchemaComponent.ValidationStatus.UNVALIDATED) {
            this.setFixupStatus(SchemaComponent.ValidationStatus.VALIDATING);
            IdentityConstraint key = (IdentityConstraint)PreparedSchema.validateReference(this, compiler, false);
            if (key == null) {
                this.setFixupStatus(SchemaComponent.ValidationStatus.INVALID);
                return false;
            }
            if (key instanceof KeyRef) {
                compiler.error("The key reference " + Err.wrap(this.getTargetComponentName().getDisplayName()) + " refers to a key reference, not to a key or unique constraint", this);
                this.target = null;
                this.setFixupStatus(SchemaComponent.ValidationStatus.INVALID);
                return false;
            }
            key.fixup(compiler);
        }
        this.setFixupStatus(SchemaComponent.ValidationStatus.VALIDATED);
        return true;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        boolean result = super.validate(compiler);
        this.tryToResolve(compiler);
        if (this.target == null) {
            compiler.error("Identity constraint " + Err.wrap(this.getTargetComponentName().getDisplayName()) + " is referenced, but has not been declared", this);
            result = false;
        } else if (this.target instanceof KeyRef) {
            compiler.error("The key reference " + Err.wrap(this.getTargetComponentName().getDisplayName()) + " refers to a key reference, not to a key or unique constraint", this);
            result = false;
        } else if (this.getFields().size() != this.target.getFields().size()) {
            compiler.error("The key reference " + Err.wrap(this.getTargetComponentName().getDisplayName()) + " has a different number of fields from the identity constraint that it references", this);
            result = false;
        }
        return result;
    }
}

