/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.BigDecimalValue;

public class VersionControlFilter
extends ProxyReceiver {
    private StartTagBuffer startTag;
    private SchemaCompiler compiler;
    private int depthOfHole = 0;
    private boolean emptySchemaElement = false;
    private BigDecimalValue thisVersion;
    private boolean isXSD11;
    private boolean foundErrors;
    private static FingerprintedQName XS_SCHEMA = new FingerprintedQName("xs", "http://www.w3.org/2001/XMLSchema", "schema", 617);

    public VersionControlFilter(SchemaCompiler compiler, Receiver next) {
        super(next);
        this.compiler = compiler;
        int xsdVersion = compiler.getLanguageVersion();
        this.thisVersion = new BigDecimalValue(new BigDecimal(xsdVersion == 10 ? "1.0" : "1.1"));
        this.isXSD11 = xsdVersion == 11;
    }

    public void setStartTagBuffer(StartTagBuffer stb) {
        this.startTag = stb;
    }

    @Override
    public void open() throws XPathException {
        this.nextReceiver.open();
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        if (this.emptySchemaElement) {
            ++this.depthOfHole;
            return;
        }
        if (this.depthOfHole == 0) {
            boolean ignore = false;
            AttributeCollection atts = this.startTag.getAllAttributes();
            int numberOfAttributes = atts.getLength();
            block20: for (int a = 0; a < numberOfAttributes; ++a) {
                if (!atts.getNodeName(a).hasURI("http://www.w3.org/2007/XMLSchema-versioning")) continue;
                String localName = atts.getNodeName(a).getLocalPart();
                try {
                    switch (localName) {
                        case "minVersion": {
                            BigDecimalValue dv = this.parseDecimalValue(atts.getValue(a));
                            if (this.thisVersion.compareTo(dv) >= 0) continue block20;
                            ignore = true;
                            break block20;
                        }
                        case "maxVersion": {
                            BigDecimalValue dv = this.parseDecimalValue(atts.getValue(a));
                            if (this.thisVersion.compareTo(dv) < 0) continue block20;
                            ignore = true;
                            break block20;
                        }
                        case "typeAvailable": {
                            Set<StructuredQName> typesAvailable = this.parseListOfQNames(atts.getValue(a), this.startTag);
                            for (StructuredQName structuredQName : typesAvailable) {
                                if (this.isAutomaticallyKnownTypeName(structuredQName)) continue;
                                ignore = true;
                                break block20;
                            }
                            continue block20;
                        }
                        case "typeUnavailable": {
                            Set<StructuredQName> typesUnavailable = this.parseListOfQNames(atts.getValue(a), this.startTag);
                            ignore = true;
                            for (Object name2 : typesUnavailable) {
                                if (this.isAutomaticallyKnownTypeName((StructuredQName)name2)) continue;
                                ignore = false;
                                break block20;
                            }
                            continue block20;
                        }
                        case "facetAvailable": {
                            Object name2;
                            Set<StructuredQName> set = this.parseListOfQNames(atts.getValue(a), this.startTag);
                            name2 = set.iterator();
                            while (name2.hasNext()) {
                                StructuredQName name = name2.next();
                                if (this.isKnownFacetName(name)) continue;
                                ignore = true;
                                break block20;
                            }
                            continue block20;
                        }
                        case "facetUnavailable": {
                            Set<StructuredQName> facetsUnavailable = this.parseListOfQNames(atts.getValue(a), this.startTag);
                            ignore = true;
                            for (StructuredQName name : facetsUnavailable) {
                                if (this.isKnownFacetName(name)) continue;
                                ignore = false;
                                break block20;
                            }
                            continue block20;
                        }
                        default: {
                            this.compiler.warning("Unrecognized attribute name " + atts.getQName(a), location);
                        }
                    }
                    continue;
                }
                catch (XPathException e) {
                    try {
                        this.compiler.error("Invalid value for attribute " + atts.getQName(a) + ": " + e.getMessage(), location);
                        this.foundErrors = true;
                        continue;
                    }
                    catch (SchemaException schemaException) {
                        // empty catch block
                    }
                }
            }
            if (ignore) {
                if (elemName.equals(XS_SCHEMA)) {
                    this.emptySchemaElement = true;
                } else {
                    this.depthOfHole = 1;
                    return;
                }
            }
            this.nextReceiver.startElement(elemName, typeCode, location, properties);
        } else {
            ++this.depthOfHole;
        }
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.namespace(namespaceBindings, properties);
        }
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
        }
    }

    @Override
    public void startContent() throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.startContent();
        }
    }

    @Override
    public void endElement() throws XPathException {
        if (this.depthOfHole > 0) {
            --this.depthOfHole;
        } else {
            this.nextReceiver.endElement();
        }
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) {
    }

    @Override
    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
    }

    @Override
    public void endDocument() throws XPathException {
        super.endDocument();
        if (this.foundErrors) {
            throw new XPathException("One or more errors were found in the content of schema versioning attributes");
        }
    }

    private BigDecimalValue parseDecimalValue(String value) throws ValidationException {
        return (BigDecimalValue)BigDecimalValue.makeDecimalValue(value, true).asAtomic();
    }

    private Set<StructuredQName> parseListOfQNames(String value, NamespaceResolver resolver) throws XPathException {
        HashSet<StructuredQName> result = new HashSet<StructuredQName>(4);
        StringTokenizer tokenizer = new StringTokenizer(value, " \t\n\r", false);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            StructuredQName val = StructuredQName.fromLexicalQName(tok, true, false, resolver);
            result.add(val);
        }
        return result;
    }

    private boolean isKnownFacetName(StructuredQName name) {
        String localName = name.getLocalPart();
        return name.hasURI("http://www.w3.org/2001/XMLSchema") && Facet.isFacetName(localName, this.isXSD11 ? 11 : 10) || name.hasURI("http://saxon.sf.net/") && localName.equals("preprocess");
    }

    private boolean isAutomaticallyKnownTypeName(StructuredQName name) {
        int fp = StandardNames.getFingerprint(name.getURI(), name.getLocalPart());
        return fp != -1 && BuiltInType.getSchemaType(fp) != null && (this.isXSD11 || fp != 575);
    }
}

