/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.Assertion;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.validate.AnyTypeValidator;
import com.saxonica.ee.validate.AssertionTreeBuilder;
import com.saxonica.ee.validate.AttributeValidator;
import com.saxonica.ee.validate.ComplexContentValidator;
import com.saxonica.ee.validate.ConstraintChecker;
import com.saxonica.ee.validate.ContentValidator;
import com.saxonica.ee.validate.EmptyContentValidator;
import com.saxonica.ee.validate.LaxValidator;
import com.saxonica.ee.validate.SimpleContentValidator;
import com.saxonica.ee.validate.SkipValidator;
import com.saxonica.ee.validate.StartTagBufferEE;
import com.saxonica.ee.validate.ValidatingFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.wrapper.VirtualCopy;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Whitespace;

public class ValidationStack
extends ValidatingFilter {
    private Stack<ContentValidator> stack = new Stack();
    private Stack<Location> locationStack = new Stack();
    private boolean contentStarted = false;
    private Receiver outputReceiver;
    private ContentValidator initialValidator;
    private List<ValidationFailure> xsiValidationErrors;
    private int initialValidationMode;
    private SchemaType initialType;
    private boolean isNilled = false;
    private NodeName topLevelElement = null;
    private AssertionTreeBuilder assertionBuilder;
    private TinyBuilder builder;
    private int builderDepth;
    private Map<SchemaComponent, Integer> statistics;

    public ValidationStack(Receiver next, int initialValidationMode, SchemaType initialType) {
        super(next);
        this.outputReceiver = next;
        this.initialValidationMode = initialValidationMode;
        this.initialType = initialType;
        PipelineConfiguration pipe = next.getPipelineConfiguration();
        this.setPipelineConfiguration(pipe);
        this.assertionBuilder = (AssertionTreeBuilder)pipe.getComponent(AssertionTreeBuilder.class.getName());
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        if (pipe.getController() == null) {
            Controller controller = new Controller(pipe.getConfiguration());
            controller.getExecutable().setSchemaAware(true);
            pipe.setController(controller);
        }
        if (pipe.getParseOptions().getValidationStatisticsRecipient() != null) {
            this.setKeepStatistics(true);
        }
    }

    public void setTopLevelElement(NodeName name) {
        this.topLevelElement = name;
    }

    public NodeName getTopLevelElement() {
        return this.topLevelElement;
    }

    @Override
    public void setUnparsedEntity(String name, String uri, String publicId) throws XPathException {
        super.setUnparsedEntity(name, uri, publicId);
        ConstraintChecker cc = this.getConstraintChecker();
        if (cc != null) {
            cc.setUnparsedEntity(name, uri, publicId);
        }
    }

    public void setIsNilled(boolean nilled) {
        this.isNilled = nilled;
    }

    public void setXsiValidationErrors(List<ValidationFailure> errors) {
        this.xsiValidationErrors = errors;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        block42: {
            this.locationStack.push(location.saveLocation());
            SchemaType xsiType = this.getValidationContext().getXSIType();
            if (this.isNilled) {
                properties |= 0x10;
            }
            PipelineConfiguration pipe = this.getPipelineConfiguration();
            try {
                int fp = elemName.obtainFingerprint(this.getNamePool());
                if (this.stack.isEmpty()) {
                    ElementDecl element;
                    ConstraintChecker constraintChecker;
                    ContentValidator initial;
                    if (this.initialValidator != null && xsiType == null) {
                        initial = this.initialValidator;
                    } else {
                        ElementDecl decl;
                        if (this.topLevelElement != null && !this.topLevelElement.equals(elemName)) {
                            String actual;
                            String required = Err.wrap(this.topLevelElement.getDisplayName(), 1);
                            if (required.equals(actual = Err.wrap(elemName.getDisplayName(), 1))) {
                                required = this.topLevelElement.getStructuredQName().getEQName();
                                actual = elemName.getStructuredQName().getEQName();
                            }
                            ValidationFailure ve = new ValidationFailure("Top-level element name is " + actual + ", required name is " + required);
                            this.reportValidationError(ve, false, location);
                        }
                        Receiver initialReceiver = this.getNextReceiver();
                        ArrayList<ValidationFailure> failures = new ArrayList<ValidationFailure>(1);
                        if (xsiType != null) {
                            SchemaType type;
                            if (initialReceiver instanceof EmptyContentValidator || initialReceiver instanceof AnyTypeValidator || initialReceiver instanceof LaxValidator) {
                                initial = ContentValidator.makeValidatorForType(null, xsiType, pipe, this.outputReceiver, failures);
                            } else if (initialReceiver instanceof SimpleContentValidator) {
                                type = ((SimpleContentValidator)initialReceiver).getSchemaType();
                                try {
                                    this.getConfiguration().checkTypeDerivationIsOK(xsiType, type, 0);
                                }
                                catch (SchemaException e) {
                                    throw new XPathException(e);
                                }
                                ((SimpleContentValidator)initialReceiver).setSchemaType(xsiType);
                                initial = (ContentValidator)this.getNextReceiver();
                            } else if (initialReceiver instanceof ComplexContentValidator) {
                                type = ((ComplexContentValidator)initialReceiver).getSchemaType();
                                try {
                                    this.getConfiguration().checkTypeDerivationIsOK(xsiType, type, 0);
                                }
                                catch (SchemaException e) {
                                    throw new XPathException(e);
                                }
                                ((ComplexContentValidator)initialReceiver).setSchemaType((UserComplexType)xsiType);
                                initial = (ContentValidator)this.getNextReceiver();
                            } else {
                                decl = (ElementDecl)this.getConfiguration().getElementDeclaration(fp);
                                initial = ContentValidator.makeValidator(decl, elemName.getStructuredQName(), location, this.getValidationContext(), xsiType, this.initialValidationMode, pipe, this.outputReceiver, (List<ValidationFailure>)failures);
                            }
                        } else if (initialReceiver instanceof ContentValidator) {
                            initial = (ContentValidator)this.getNextReceiver();
                        } else if (this.initialType != null) {
                            initial = ContentValidator.makeValidatorForType(null, this.initialType, pipe, this.outputReceiver, failures);
                        } else {
                            decl = (ElementDecl)this.getConfiguration().getElementDeclaration(fp);
                            initial = ContentValidator.makeValidator(decl, elemName.getStructuredQName(), location, this.getValidationContext(), null, this.initialValidationMode, pipe, this.outputReceiver, (List<ValidationFailure>)failures);
                        }
                        if (!failures.isEmpty()) {
                            this.reportValidationError((ValidationFailure)failures.get(0), false, location);
                            initial = new LaxValidator(this.getNextReceiver());
                        }
                        assert (initial != null);
                        initial.setValidationContext(this.getValidationContext());
                    }
                    SchemaType annotation = initial.getAnnotation();
                    initial.setConstraintChecker(this.getConstraintChecker());
                    if (this.isNilled) {
                        properties |= 0x10;
                    }
                    if (!(initial instanceof SkipValidator) && !this.xsiValidationErrors.isEmpty()) {
                        for (ValidationFailure err : this.xsiValidationErrors) {
                            this.reportValidationError(err, false, location);
                        }
                    }
                    SchemaType type = initial.getSchemaType();
                    if (initial instanceof SimpleContentValidator && type.isIdType()) {
                        pipe.getErrorListener().warning(new XPathException("During validation, using an ID element at the outermost level has no effect"));
                    }
                    if ((constraintChecker = this.getConstraintChecker()) != null && (element = initial.getElementDeclaration()) != null) {
                        constraintChecker.setElementDeclaration(element);
                    }
                    this.outputReceiver.startElement(elemName, annotation, location, properties);
                    if (type instanceof UserComplexType && ((UserComplexType)type).hasAssertions()) {
                        this.builder = new TinyBuilder(pipe);
                        this.builder.setStatistics(pipe.getConfiguration().getTreeStatistics().ASSERTION_TREE_STATISTICS);
                        this.builder.setLineNumbering(true);
                        this.builder.open();
                        this.builder.startElement(elemName, typeCode, location, properties);
                        StartTagBufferEE nr = this.getValidationContext().getStartTagBuffer();
                        Iterator<String> iter = nr.iteratePrefixes();
                        while (iter.hasNext()) {
                            String prefix = iter.next();
                            String uri = nr.getURIForPrefix(prefix, true);
                            this.builder.namespace(new NamespaceBinding(prefix, uri), 0);
                        }
                        this.builderDepth = 0;
                        this.assertionBuilder.activate(this.builder);
                    }
                    this.stack.push(initial);
                } else {
                    Object type;
                    if (!this.contentStarted) {
                        this.startContent();
                    }
                    ContentValidator v0 = this.stack.peek();
                    v0.startElement(elemName, typeCode, location, properties);
                    ContentValidator v1 = v0.getChildValidator();
                    v1.setValidationContext(this.getValidationContext());
                    v1.setUnderlyingReceiver(this.outputReceiver);
                    if (this.statistics != null) {
                        this.incrementStatistics(v1.getElementDeclaration());
                        this.incrementStatistics(v1.getSchemaType());
                    }
                    this.setUnderlyingReceiver(v1);
                    this.stack.push(v1);
                    this.contentStarted = false;
                    if (!(v1 instanceof SkipValidator) && !this.xsiValidationErrors.isEmpty()) {
                        type = this.xsiValidationErrors.iterator();
                        while (type.hasNext()) {
                            ValidationFailure err = (ValidationFailure)type.next();
                            this.reportValidationError(err, false, location);
                        }
                    }
                    if (this.builder == null && (type = v1.getSchemaType()) instanceof UserComplexType && ((UserComplexType)type).hasAssertions()) {
                        this.builder = new TinyBuilder(pipe);
                        this.builder.setStatistics(pipe.getConfiguration().getTreeStatistics().ASSERTION_TREE_STATISTICS);
                        this.builder.open();
                        this.builder.startElement(elemName, typeCode, location, properties);
                        StartTagBufferEE nr = this.getValidationContext().getStartTagBuffer();
                        Iterator<String> iter = nr.iteratePrefixes();
                        while (iter.hasNext()) {
                            String prefix = iter.next();
                            String uri = nr.getURIForPrefix(prefix, true);
                            this.builder.namespace(new NamespaceBinding(prefix, uri), 0);
                        }
                        this.builderDepth = 0;
                        this.assertionBuilder.activate(this.builder);
                    }
                }
                if (this.builder != null) {
                    ++this.builderDepth;
                }
            }
            catch (ValidationException ve) {
                if (!ve.hasBeenReported()) {
                    this.reportValidationError(ve.getValidationFailure(), true, location);
                    ve.setHasBeenReported(true);
                }
                if (pipe.isRecoverFromValidationErrors()) break block42;
                throw ve;
            }
        }
    }

    public void setInitialValidator(ContentValidator validator) {
        this.initialValidator = validator;
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        SimpleType type;
        ContentValidator v0 = this.stack.peek();
        v0.setStartTagBuffer(this.getStartTagBuffer());
        v0.attribute(nameCode, typeCode, value, locationId, properties);
        if (this.statistics != null && v0 instanceof AttributeValidator && (type = ((AttributeValidator)v0).getMostRecentAttributeType()) != null) {
            this.incrementStatistics(type);
        }
    }

    @Override
    public final void startContent() throws XPathException {
        this.contentStarted = true;
        ContentValidator v0 = this.stack.peek();
        v0.startContent();
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (!this.contentStarted) {
            this.startContent();
        }
        ContentValidator v0 = this.stack.peek();
        v0.characters(chars, locationId, properties);
    }

    @Override
    public void endElement() throws XPathException {
        Location location = this.locationStack.pop();
        if (!this.contentStarted) {
            this.startContent();
        }
        ContentValidator v0 = this.stack.pop();
        v0.endElement();
        if (this.builder != null) {
            --this.builderDepth;
            SchemaType type = v0.getSchemaType();
            if (type instanceof UserComplexType && ((UserComplexType)type).hasAssertions()) {
                NodeInfo root = this.builder.getLastCompletedElement();
                if (this.builderDepth != 0) {
                    root = VirtualCopy.makeVirtualCopy(root);
                }
                this.testAssertions(root, (UserComplexType)type, location);
            }
            if (this.builderDepth == 0) {
                this.builder.close();
                this.assertionBuilder.deactivate();
                this.builder = null;
            }
        }
        if (!this.stack.isEmpty()) {
            this.setUnderlyingReceiver(this.stack.peek());
        } else {
            this.setUnderlyingReceiver(this.outputReceiver);
            this.reportIfInvalid();
        }
    }

    @Override
    public void endDocument() throws XPathException {
        this.nextReceiver.endDocument();
        this.reportIfInvalid();
        if (this.statistics != null) {
            this.getPipelineConfiguration().getParseOptions().getValidationStatisticsRecipient().notifyValidationStatistics(this.statistics);
        }
    }

    private void testAssertions(NodeInfo root, UserComplexType type, Location location) throws XPathException {
        Set<Assertion> assertions = type.getAssertions();
        AtomicSequence value = null;
        if (type.isSimpleContent()) {
            CharSequence s = root.getStringValueCS();
            SimpleType st = type.getSimpleContentType();
            InscopeNamespaceResolver ns = st.isNamespaceSensitive() ? new InscopeNamespaceResolver(root) : null;
            value = st.getTypedValue(s, ns, this.getConfiguration().getConversionRules());
        }
        for (Assertion assertion : assertions) {
            List<NodeInfo> offendingItems = assertion.testComplex(root, value, this.getValidationContext());
            if (offendingItems.isEmpty()) continue;
            String message = "Element " + root.getDisplayName() + " does not satisfy assertion";
            message = assertion.getMessage() != null ? message + ". " + assertion.getMessage() : message + " " + Whitespace.collapseWhitespace(assertion.getConditionText());
            ValidationFailure error = new ValidationFailure(message);
            error.setLocator(location);
            error.setConstraintReference(1, "sec-cvc-assertion", "0");
            for (NodeInfo item : offendingItems) {
                if (item == root) continue;
                error.addOffendingNode(item);
            }
            this.reportValidationError(error, true, location);
        }
    }

    private void incrementStatistics(SchemaComponent component) {
        this.statistics.merge(component, 1, (a, b) -> a + b);
    }

    public void setKeepStatistics(boolean keep) {
        this.statistics = keep ? new HashMap<SchemaComponent, Integer>() : null;
    }

    public Map<SchemaComponent, Integer> getCoverageStatistics() {
        return this.statistics;
    }
}

