/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.DigitsFacet;
import com.saxonica.ee.schema.EnumerationFacet;
import com.saxonica.ee.schema.ExplicitTimezoneFacet;
import com.saxonica.ee.schema.FractionDigitsFacet;
import com.saxonica.ee.schema.LengthFacet;
import com.saxonica.ee.schema.MaxExclusiveFacet;
import com.saxonica.ee.schema.MaxInclusiveFacet;
import com.saxonica.ee.schema.MaxLengthFacet;
import com.saxonica.ee.schema.MinExclusiveFacet;
import com.saxonica.ee.schema.MinInclusiveFacet;
import com.saxonica.ee.schema.MinLengthFacet;
import com.saxonica.ee.schema.PatternFacet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.TotalDigitsFacet;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.WhitespaceFacet;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;

public abstract class Facet {
    private boolean fixed = false;
    private String message = null;

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isConstraining() {
        return true;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public abstract String getName();

    public String getConstraintName() {
        return "cvc-" + this.getName() + "-valid";
    }

    public abstract String getValue();

    public long toLong() throws NumberFormatException {
        return Long.parseLong(this.getValue());
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
    }

    public boolean isNewlyIntroduced(SimpleType base) {
        Class<?> thisClass = this.getClass();
        if (base instanceof UserSimpleType) {
            Facet f = ((UserSimpleType)base).getFacet(thisClass);
            return f == null || !this.getValue().equals(f.getValue());
        }
        return true;
    }

    public abstract boolean testAtomicValue(AtomicValue var1);

    public boolean testListValue(AtomicSequence value) {
        throw new UnsupportedOperationException("The " + this.getName() + " facet is not applicable to list values");
    }

    public boolean testLength(int count) {
        return true;
    }

    public int getWhitespaceAction() {
        return 0;
    }

    public void serializeFacet(SchemaModelSerializer serializer) throws XPathException {
        String flags;
        serializer.startElement(this.getName());
        if (this.getValue() == null) {
            throw new NullPointerException("*** Facet " + this.getName() + " has no value");
        }
        serializer.emitAttribute("value", this.getValue());
        if (this.isFixed()) {
            serializer.emitAttribute("fixed", "true");
        }
        if (this.message != null) {
            serializer.emitAttribute("message", this.message);
        }
        if (this instanceof PatternFacet && (flags = ((PatternFacet)this).getFlags()) != null && !flags.isEmpty()) {
            serializer.emitAttribute("flags", flags);
        }
        serializer.endElement();
    }

    public static boolean isFacetName(String name, int xsdVersion) {
        return "assertion".equals(name) && xsdVersion == 11 || "enumeration".equals(name) || "length".equals(name) || "pattern".equals(name) || "maxExclusive".equals(name) || "minExclusive".equals(name) || "maxInclusive".equals(name) || "minInclusive".equals(name) || "maxLength".equals(name) || "minLength".equals(name) || "maxScale".equals(name) || "minScale".equals(name) || "whiteSpace".equals(name) || "totalDigits".equals(name) || "fractionDigits".equals(name) || "explicitTimezone".equals(name) && xsdVersion == 11;
    }

    public abstract Function getFacetAsFunctionItem();

    public static Facet makeFacet(String name, String value, EnterpriseConfiguration config, NamespaceResolver resolver, SchemaCompiler compiler) throws SchemaException {
        switch (name) {
            case "pattern": {
                PatternFacet lf = new PatternFacet(config);
                lf.setValue(value);
                return lf;
            }
            case "enumeration": {
                EnumerationFacet ef = new EnumerationFacet();
                ef.setValue(value);
                ef.setNamespaceContext(resolver);
                return ef;
            }
            case "length": {
                LengthFacet lf = new LengthFacet();
                lf.setValue(value);
                return lf;
            }
            case "minLength": {
                MinLengthFacet lf = new MinLengthFacet();
                lf.setValue(value);
                return lf;
            }
            case "maxLength": {
                MaxLengthFacet lf = new MaxLengthFacet();
                lf.setValue(value);
                return lf;
            }
            case "minInclusive": {
                MinInclusiveFacet vrf = new MinInclusiveFacet();
                vrf.setValue(value);
                return vrf;
            }
            case "maxInclusive": {
                MaxInclusiveFacet vrf = new MaxInclusiveFacet();
                vrf.setValue(value);
                return vrf;
            }
            case "minExclusive": {
                MinExclusiveFacet vrf = new MinExclusiveFacet();
                vrf.setValue(value);
                return vrf;
            }
            case "maxExclusive": {
                MaxExclusiveFacet vrf = new MaxExclusiveFacet();
                vrf.setValue(value);
                return vrf;
            }
            case "totalDigits": {
                TotalDigitsFacet df = new TotalDigitsFacet();
                ((DigitsFacet)df).setValue(value);
                return df;
            }
            case "fractionDigits": {
                FractionDigitsFacet df = new FractionDigitsFacet();
                ((DigitsFacet)df).setValue(value);
                return df;
            }
            case "explicitTimezone": {
                ExplicitTimezoneFacet tf = new ExplicitTimezoneFacet();
                tf.setValue(value);
                return tf;
            }
            case "whiteSpace": {
                WhitespaceFacet wf = new WhitespaceFacet();
                wf.setValue(value);
                return wf;
            }
        }
        throw new SchemaException("Unknown facet: " + name);
    }
}

