/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.trans.Outcome;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class PushToPull {
    private Pusher expression;
    private XPathContext context;
    private final BlockingQueue<Outcome<Item>> queue = new ArrayBlockingQueue<Outcome<Item>>(50);
    private final Item stopper = new StringValue("finished");

    public PushToPull(Pusher expression, XPathContext context) {
        this.expression = expression;
        this.context = context;
    }

    public SequenceIterator<Item<?>> getIterator() {
        EnterpriseConfiguration config = (EnterpriseConfiguration)this.context.getConfiguration();
        final Thread provider = config.getMultithreadingFactory().makeThread(new Provider());
        provider.start();
        return new SequenceIterator<Item<?>>(){
            boolean allDone = false;

            @Override
            public Item next() throws XPathException {
                if (this.allDone) {
                    return null;
                }
                try {
                    Outcome next = (Outcome)PushToPull.this.queue.take();
                    if (next.isSuccess()) {
                        Item item = (Item)next.getResult();
                        if (item == PushToPull.this.stopper) {
                            this.allDone = true;
                            return null;
                        }
                        return item;
                    }
                    throw XPathException.makeXPathException(next.getException());
                }
                catch (InterruptedException e) {
                    throw new XPathException(e);
                }
            }

            @Override
            public void close() {
                this.allDone = true;
                provider.interrupt();
            }
        };
    }

    private class Provider
    implements Runnable {
        private Provider() {
        }

        @Override
        public void run() {
            PipelineConfiguration pipe = PushToPull.this.context.getController().makePipelineConfiguration();
            pipe.setXPathContext(PushToPull.this.context);
            QueueWriter q = new QueueWriter(pipe);
            XPathContextMinor c2 = PushToPull.this.context.newMinorContext();
            c2.setReceiver(q);
            try {
                PushToPull.this.expression.push(c2);
                q.write(PushToPull.this.stopper);
            }
            catch (QuitParsingException quit) {
                if (!quit.isNotifiedByConsumer()) {
                    try {
                        q.write(PushToPull.this.stopper);
                    }
                    catch (XPathException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (XPathException err) {
                q.notify(err);
            }
        }
    }

    private class QueueWriter
    extends SequenceWriter {
        public QueueWriter(PipelineConfiguration pipe) {
            super(pipe);
        }

        @Override
        public void write(Item item) throws XPathException {
            if (Thread.currentThread().isInterrupted()) {
                throw new QuitParsingException(true);
            }
            try {
                PushToPull.this.queue.put(new Outcome<Item>(item));
            }
            catch (InterruptedException e) {
                throw new QuitParsingException(true);
            }
        }

        public void notify(XPathException exception) {
            try {
                PushToPull.this.queue.clear();
                PushToPull.this.queue.put(new Outcome(exception));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static interface Pusher {
        public void push(XPathContext var1) throws XPathException;
    }
}

