/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import com.saxonica.xsltextn.style.SaxonTypeAlias;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.XSLImportSchema;
import net.sf.saxon.style.XSLPackage;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;

public class PrincipalStylesheetModuleEE
extends PrincipalStylesheetModule {
    private Map<Expression, GlobalVariable> indexOfVariablesByInitializer = new HashMap<Expression, GlobalVariable>();

    public PrincipalStylesheetModuleEE(XSLPackage node) throws XPathException {
        super(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void importSchemata() throws XPathException {
        boolean importsSchemas = false;
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            ComponentDeclaration decl = (ComponentDeclaration)this.topLevel.get(i);
            if (!(decl.getSourceElement() instanceof XSLImportSchema)) continue;
            importsSchemas = true;
        }
        if (importsSchemas) {
            Configuration configuration = this.getConfiguration();
            synchronized (configuration) {
                for (int i = this.topLevel.size() - 1; i >= 0; --i) {
                    ComponentDeclaration decl = (ComponentDeclaration)this.topLevel.get(i);
                    if (decl.getSourceElement() instanceof XSLImportSchema) {
                        ((XSLImportSchema)decl.getSourceElement()).readSchema();
                    }
                    if (!(decl.getSourceElement() instanceof SaxonTypeAlias)) continue;
                    ((SaxonTypeAlias)decl.getSourceElement()).indexTypeAlias(decl, this);
                }
                Configuration config = this.getConfiguration();
                for (String ns : this.getStylesheetPackage().getSchemaNamespaces()) {
                    config.sealNamespace(ns);
                }
            }
        }
    }

    @Override
    protected void checkStreamability(AttributeSet aSet) throws XPathException {
        ArrayList<String> reasons = new ArrayList<String>();
        Expression body = aSet.getBody();
        if (body != null) {
            ContextItemStaticInfoEE info = (ContextItemStaticInfoEE)this.getConfiguration().makeContextItemStaticInfo(AnyItemType.getInstance(), true);
            info.setContainer(aSet);
            PostureAndSweep s1 = Streamability.getStreamability(body, info, reasons);
            if (s1.getPosture() != Posture.GROUNDED) {
                String message = "Attribute set " + aSet.getObjectName().getDisplayName() + " is declared streamable but is not actually streamable. ";
                for (String s : reasons) {
                    message = message + "\n    " + s;
                }
                XPathException err = new XPathException(message, "XTSE3430");
                err.setLocator(aSet);
                this.compileError(err);
            }
        }
    }

    private static boolean isVariableReusable(GlobalVariable variable) {
        Expression select = variable.getSelectExpression();
        return select != null && !variable.isAssignable() && !(variable instanceof GlobalParam) && (select.getDependencies() & 0x800) == 0;
    }

    @Override
    public void addGlobalVariable(GlobalVariable variable) {
        super.addGlobalVariable(variable);
        if (PrincipalStylesheetModuleEE.isVariableReusable(variable)) {
            this.indexOfVariablesByInitializer.put(variable.getSelectExpression(), variable);
        }
    }

    @Override
    public GlobalVariable getEquivalentVariable(Expression select) {
        return this.indexOfVariablesByInitializer.get(select);
    }
}

