/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToPushCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.NextIteration;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.type.TypeHierarchy;

public class NextIterationCompiler
extends ToPushCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        NextIteration instr = (NextIteration)expression;
        Configuration config = compiler.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        NextIterationCompiler.visitLineNumber(compiler, ga, expression);
        NextIterationCompiler.visitAnnotation(compiler, "NextIteration-push");
        WithParam[] actualParams = instr.getParameters();
        if (actualParams.length == 1) {
            compiler.generateGetContext();
            ga.checkClass(XPathContextMajor.class);
            ga.push(actualParams[0].getSlotNumber());
            compiler.compileToSequence(actualParams[0].getSelectExpression());
            ga.invokeInstanceMethod(XPathContextMajor.class, "setLocalVariable", Integer.TYPE, Sequence.class);
        } else {
            compiler.generateGetContext();
            ga.checkClass(XPathContextMajor.class);
            ga.invokeInstanceMethod(XPathContextMajor.class, "getAllVariableValues", new Class[0]);
            int oldVarsVar = methodInfo.allocateLocal(Sequence[].class);
            ga.storeLocal(oldVarsVar);
            ga.loadLocal(oldVarsVar);
            ga.arrayLength();
            ga.newArray(Type.getType(Sequence.class));
            int newVarsVar = methodInfo.allocateLocal(Sequence[].class);
            ga.storeLocal(newVarsVar);
            ga.loadLocal(oldVarsVar);
            ga.push(0);
            ga.loadLocal(newVarsVar);
            ga.push(0);
            ga.loadLocal(oldVarsVar);
            ga.arrayLength();
            ga.invokeStaticMethod(System.class, "arraycopy", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
            for (int i = 0; i < actualParams.length; ++i) {
                WithParam wp = actualParams[i];
                ga.loadLocal(newVarsVar);
                ga.push(wp.getSlotNumber());
                compiler.compileToSequence(wp.getSelectExpression());
                ga.arrayStore(Type.getType(Sequence.class));
            }
            compiler.generateGetContext();
            ga.checkClass(XPathContextMajor.class);
            ga.loadLocal(newVarsVar);
            ga.invokeInstanceMethod(XPathContextMajor.class, "resetAllVariableValues", Sequence[].class);
        }
        ga.goTo(methodInfo.getXslIterateLoopLabelStack().peek());
    }
}

