/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToBooleanCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.functions.Contains;
import net.sf.saxon.lib.SubstringMatcher;

public class ContainsCompiler
extends ToBooleanCompiler {
    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        SystemFunctionCall fnc = (SystemFunctionCall)expression;
        Contains contains = (Contains)fnc.getTargetFunction();
        Expression arg0 = fnc.getArg(0);
        Expression arg1 = fnc.getArg(1);
        SubstringMatcher stringCollator = (SubstringMatcher)contains.getStringCollator();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ContainsCompiler.visitAnnotation(compiler, "ContainsCompiler");
        ContainsCompiler.visitLineNumber(compiler, ga, expression);
        if (stringCollator instanceof CodepointCollator) {
            LabelInfo end = methodInfo.newLabel("endContains");
            LabelInfo returnTrue = methodInfo.newLabel("returnTrue");
            compiler.compileToPrimitive(arg0, String.class, OnEmpty.RETURN_EMPTY_STRING);
            compiler.compileToPrimitive(arg1, String.class, OnEmpty.RETURN_EMPTY_STRING);
            ga.push(0);
            ga.invokeInstanceMethod(String.class, "indexOf", String.class, Integer.TYPE);
            ga.ifZCmp(156, returnTrue.label());
            ga.push(false);
            ga.goTo(end);
            methodInfo.placeLabel(returnTrue);
            ga.push(true);
            methodInfo.placeLabel(end);
        } else {
            ContainsCompiler.allocateStatic(compiler, stringCollator);
            compiler.compileToPrimitive(arg0, String.class, OnEmpty.RETURN_EMPTY_STRING);
            compiler.compileToPrimitive(arg1, String.class, OnEmpty.RETURN_EMPTY_STRING);
            ga.invokeInstanceMethod(SubstringMatcher.class, "contains", String.class, String.class);
        }
    }
}

