/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.AllModelGroup;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.ElementWildcard;
import com.saxonica.ee.schema.ModelGroupParticle;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.Wildcard;
import com.saxonica.ee.validate.AnyTypeValidator;
import com.saxonica.ee.validate.AttributeValidator;
import com.saxonica.ee.validate.ContentValidator;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntToIntMap;

public class AllElementValidator
extends AttributeValidator {
    private UserComplexType type;
    private AllModelGroup allGroup;
    boolean mixed;
    boolean empty = true;
    boolean emptiable;
    int[] counters;
    boolean ignoreIgnorable;
    boolean inOpenSuffix;

    protected AllElementValidator(UserComplexType type, Receiver next) throws MissingComponentException {
        super(next);
        this.type = type;
        this.mixed = type.isMixedContent();
        this.setAnnotation(type);
        this.setAttributeGroup(type.getCombinedAttributeGroup());
        ModelGroupParticle allParticle = type.getAllCompositor();
        if (allParticle == null) {
            throw new IllegalStateException("Calling xs:all validator, cannot find xs:all compositor");
        }
        this.allGroup = (AllModelGroup)allParticle.getGroup();
        this.emptiable = allParticle.isEmptiable();
        this.counters = new int[this.allGroup.getMinima().length];
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.ignoreIgnorable = this.getConfiguration().getParseOptions().getSpaceStrippingRule() != NoElementsSpaceStrippingRule.getInstance();
    }

    @Override
    public SchemaType getSchemaType() {
        return this.type;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        boolean exhausted;
        Configuration config = this.getConfiguration();
        NamePool pool = config.getNamePool();
        SchemaType annotation = null;
        int key = elemName.obtainFingerprint(pool);
        this.empty = false;
        IntToIntMap counterMap = this.allGroup.getCounterMap();
        int counter = counterMap.get(key);
        boolean foundElementParticle = counter != counterMap.getDefaultValue();
        boolean bl = exhausted = !foundElementParticle;
        if (foundElementParticle) {
            int n = counter;
            int n2 = this.counters[n] + 1;
            this.counters[n] = n2;
            int count = n2;
            int max = this.allGroup.getMaxima()[counter];
            boolean bl2 = exhausted = max != -1 && count > max;
        }
        if (exhausted) {
            Wildcard openWildcard;
            List<ElementWildcard> wildcards = this.allGroup.getWildcards();
            int w = 0;
            for (ElementWildcard wildcard : wildcards) {
                if (wildcard.getWildcard().matches(elemName, true, config, this.type)) {
                    if (this.inOpenSuffix) {
                        this.reportNotAllowedInSuffix(elemName, location);
                    }
                    int n = w;
                    int n3 = this.counters[n] + 1;
                    this.counters[n] = n3;
                    int found = n3;
                    int wmax = wildcard.getMaxOccurs();
                    if (wmax != -1 && found > wmax) {
                        this.reportExcess(elemName, location, wmax);
                        this.counters[w] = Integer.MIN_VALUE;
                    }
                    annotation = this.processWildcardTerm(wildcard.getWildcard(), elemName, location);
                    break;
                }
                ++w;
            }
            if (annotation == null && (openWildcard = this.type.getOpenContentWildcard()) != null && openWildcard.matches(elemName, true, config, this.type)) {
                annotation = this.processWildcardTerm(openWildcard, elemName, location);
                boolean bl3 = this.inOpenSuffix = this.type.getOpenContentMode() == 3;
            }
            if (annotation == null) {
                if (foundElementParticle) {
                    this.reportExcess(elemName, location, this.allGroup.getMaxima()[counter]);
                    this.counters[counter] = Integer.MIN_VALUE;
                } else {
                    String reason = "";
                    if (wildcards.size() == 1) {
                        Iterator<ElementWildcard> it = wildcards.iterator();
                        ElementWildcard wildcard = it.next();
                        reason = ". " + wildcard.getWildcard().reasonForNonMatch(elemName, true, config, this.type);
                    }
                    this.reportNotAllowed(elemName, location, reason);
                }
                this.childValidator = new AnyTypeValidator(this.getNextReceiver());
                annotation = AnyType.getInstance();
            }
        } else {
            if (this.inOpenSuffix) {
                this.reportNotAllowedInSuffix(elemName, location);
            }
            ElementDecl contextDeterminedDeclaration = (ElementDecl)this.allGroup.getDeclarationMap().get(key);
            this.makeChildValidator(contextDeterminedDeclaration, elemName.getStructuredQName(), location, 0);
            annotation = this.childValidator.getAnnotation();
        }
        super.startElement(elemName, annotation, location, properties);
    }

    private void reportExcess(NodeName elemName, Location locationId, int maxAllowed) throws XPathException {
        ValidationFailure ve = new ValidationFailure("Element " + Err.wrap(elemName.getDisplayName(), 1) + " exceeds limits defined in xs:all group: maxOccurs is " + maxAllowed);
        ve.setConstraintReference(1, "cvc-model-group", "1");
        ve.setSchemaType(this.type);
        this.reportValidationError(ve, true, locationId);
    }

    private void reportNotAllowed(NodeName elemName, Location locationId, String reason) throws XPathException {
        ValidationFailure ve = new ValidationFailure("Element " + Err.wrap(elemName.getDisplayName(), 1) + " is not allowed in the content of the xs:all group" + reason);
        ve.setConstraintReference(1, "cvc-complex-content", "1");
        ve.setSchemaType(this.type);
        this.reportValidationError(ve, true, locationId);
    }

    private void reportNotAllowedInSuffix(NodeName elemName, Location locationId) throws XPathException {
        ValidationFailure ve = new ValidationFailure("Element " + Err.wrap(elemName.getDisplayName(), 1) + " cannot appear in the content of the xs:all group after an element that matches open content with mode=suffix");
        ve.setConstraintReference(1, "cvc-complex-content", "2");
        ve.setSchemaType(this.type);
        this.reportValidationError(ve, true, locationId);
    }

    @Override
    protected ContentValidator getChildValidator() {
        return this.childValidator;
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.checkNoCharactersWhenNil(locationId);
        if (this.mixed) {
            this.nextReceiver.characters(chars, locationId, properties);
            this.empty = false;
        } else if (Whitespace.isWhite(chars)) {
            if (!this.ignoreIgnorable) {
                this.nextReceiver.characters(chars, locationId, properties);
            }
        } else {
            ValidationFailure ve = new ValidationFailure("The content model for the type " + this.type.getDescription() + " does not allow character content");
            ve.setConstraintReference(1, "cvc-complex-type", "2.3");
            ve.setSchemaType(this.type);
            this.reportValidationError(ve, true, locationId);
        }
    }

    @Override
    public void endElement() throws XPathException {
        if (!(this.empty && this.emptiable || this.isNil())) {
            List<ElementWildcard> wildcards = this.allGroup.getWildcards();
            int[] minima = this.allGroup.getMinima();
            for (int i = wildcards.size(); i < this.counters.length; ++i) {
                String container;
                int found = this.counters[i];
                if (found >= minima[i] || found < 0) continue;
                String name = this.allGroup.getNameCodes()[i].getDisplayName();
                if (this.getContainingElement() == null) {
                    if (this.type.isAnonymousType()) {
                        StructuredQName nc = this.type.getContainingDeclarationName();
                        container = "element " + nc.getDisplayName();
                    } else {
                        container = "element of type " + this.type.getDescription();
                    }
                } else {
                    container = this.getContainingElementName();
                }
                String msg = "In content of " + container + ": element " + Err.wrap(name, 1) + (found == 0 ? " is not present" : " has " + found + " occurrence" + (found == 1 ? "" : "s") + " but minOccurs is " + this.allGroup.getMinima()[i]);
                ValidationFailure ve = new ValidationFailure(msg);
                ve.setConstraintReference(1, "cvc-model-group", "3");
                ve.setSchemaType(this.type);
                this.reportValidationError(ve, true, this.getContainingElementLocationId());
            }
            int index = 0;
            for (ElementWildcard wildcard : wildcards) {
                int found;
                int min = wildcard.getMinOccurs();
                if ((found = this.counters[index++]) >= min || found < 0) continue;
                String msg = "In content of " + Err.wrap(this.getContainingElement().getDisplayName(), 1) + ": " + (found == 0 ? "No" : "Only " + found) + " child element" + (found == 1 ? "" : "s") + " found to match element wildcard with minOccurs=" + min;
                ValidationFailure ve = new ValidationFailure(msg);
                ve.setConstraintReference(1, "cvc-model-group", "3");
                ve.setSchemaType(this.type);
                this.reportValidationError(ve, true, this.getContainingElementLocationId());
            }
        }
        this.nextReceiver.endElement();
    }
}

