/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.plkexport;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.tinylog.Logger;

public class ExWSConf {
    private static String VERSION;
    private static Properties prop;

    public static String version() {
        if (VERSION != null) {
            return VERSION;
        }
        Properties projProp = new Properties();
        try {
            projProp.load(ExWSConf.class.getClassLoader().getResourceAsStream("project.properties"));
        }
        catch (Exception e) {
            Logger.error("Unable to load project properties");
            return null;
        }
        VERSION = projProp.getProperty("version");
        return VERSION;
    }

    public static void clearProp() {
        prop = null;
    }

    public static Properties loadProp(Properties aprop, String file) {
        if (aprop == null) {
            aprop = new Properties();
        }
        try {
            FileInputStream diFile = new FileInputStream(file);
            aprop.load(new BufferedReader(new InputStreamReader((InputStream)diFile, "UTF-8")));
        }
        catch (IOException t) {
            try {
                InputStream diFile = ExWSConf.class.getClassLoader().getResourceAsStream(file);
                if (diFile == null) {
                    Logger.error("Unable to load properties.");
                    return null;
                }
                aprop.load(diFile);
                diFile.close();
            }
            catch (IOException e) {
                Logger.error(e);
                return null;
            }
        }
        return aprop;
    }

    public static Properties properties(String propFile) {
        if (prop != null) {
            return prop;
        }
        Properties defaultProp = ExWSConf.loadProp(null, "exportPlugin.conf");
        prop = new Properties(defaultProp);
        if (propFile != null) {
            ExWSConf.loadProp(prop, propFile);
        }
        return prop;
    }
}

