/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.plkexport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class Util {
    public static String sanitizeFileName(String fname) {
        return fname.replaceAll("[^\\p{L}0-9\\(\\)\\-\\_]", "-").replaceAll("--+", "-").replaceAll("([\\(\\)\\_])-+", "$1").replaceAll("-+([\\(\\)\\_])", "$1").replaceFirst("^-+", "").replaceFirst("-+$", "");
    }

    public static String streamToString(InputStream in) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                sb.append(line + System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String convertToUTF8(String s) {
        if (s == null) {
            return null;
        }
        String out = null;
        try {
            out = new String(s.getBytes("UTF-8"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return out;
    }

    public static String convertFromUTF8(String s) {
        if (s == null) {
            return null;
        }
        String out = null;
        try {
            out = new String(s.getBytes("Windows-1252"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return out;
    }
}

