/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.Constructor;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

class ParameterizedTestSpiInstantiator {
    ParameterizedTestSpiInstantiator() {
    }

    static <T> T instantiate(Class<T> spiInterface, Class<? extends T> implementationClass, ExtensionContext extensionContext) {
        return extensionContext.getExecutableInvoker().invoke(ParameterizedTestSpiInstantiator.findConstructor(spiInterface, implementationClass));
    }

    private static <T> Constructor<? extends T> findConstructor(Class<T> spiInterface, Class<? extends T> implementationClass) {
        return ParameterizedTestSpiInstantiator.findBestConstructor(spiInterface, implementationClass);
    }

    private static <T> Constructor<?> findBestConstructor(Class<T> spiInterface, Class<? extends T> implementationClass) {
        Preconditions.condition(!ReflectionUtils.isInnerClass(implementationClass), () -> String.format("The %s [%s] must be either a top-level class or a static nested class", spiInterface.getSimpleName(), implementationClass.getName()));
        Constructor<?>[] constructors = implementationClass.getDeclaredConstructors();
        if (constructors.length == 1) {
            return constructors[0];
        }
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterCount() != 0) continue;
            return constructor;
        }
        String message = String.format("Failed to find constructor for %s [%s]. Please ensure that a no-argument or a single constructor exists.", spiInterface.getSimpleName(), implementationClass.getName());
        throw new JUnitException(message);
    }
}

