/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.plkexport;

import de.ids_mannheim.korap.plkexport.ExWSConf;
import de.ids_mannheim.korap.plkexport.ExpTempl;
import de.ids_mannheim.korap.plkexport.Service;
import java.util.Properties;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.servlet.ServletContainer;
import org.tinylog.Logger;

public class PluginServer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ServletContextHandler contextHandler = new ServletContextHandler(0);
        contextHandler.setContextPath("/");
        String propfile = null;
        boolean printhelp = false;
        boolean argexc = false;
        if (args.length >= 1 & args.length <= 2) {
            for (int i2 = 0; i2 <= args.length - 1; ++i2) {
                if (args[i2].equals("-h") | args[i2].equals("--help")) {
                    printhelp = true;
                    continue;
                }
                propfile = args[i2];
            }
        } else if (args.length >= 3) {
            argexc = true;
        }
        Properties properties = ExWSConf.properties(propfile);
        String usage = "\n Usage is java -jar KalamarExportPlugin-" + ExWSConf.version() + ".jar [-h|--help] [myconf_exportPlugin.conf]";
        String portStr = properties.getProperty("server.port", "7070");
        String host = properties.getProperty("server.host", "localhost");
        int port = Integer.parseInt(portStr);
        Server jettyServer = new Server();
        ServerConnector connector = new ServerConnector(jettyServer);
        connector.setPort(port);
        connector.setHost(host);
        connector.setIdleTimeout(60000L);
        jettyServer.addConnector(connector);
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{contextHandler, new DefaultHandler()});
        jettyServer.setHandler(handlers);
        ServletContainer servletContainer = new ServletContainer();
        ServletHolder servletHolder = new ServletHolder(servletContainer);
        contextHandler.addServlet(servletHolder, "/*");
        servletHolder.setInitOrder(0);
        servletHolder.setInitParameter("jersey.config.server.provider.classnames", Service.class.getCanonicalName());
        try {
            jettyServer.start();
            Logger.info("PluginServer available under: http://" + host + ":" + portStr);
            Logger.info("ApiServer expected under: " + properties.getProperty("api.scheme") + "://" + properties.getProperty("api.host") + ":" + properties.getProperty("api.port") + properties.getProperty("api.path", ""));
            if (printhelp) {
                System.out.println(usage);
                String templString = ExpTempl.getExportTempl(properties.getProperty("server.scheme"), properties.getProperty("server.host"), properties.getProperty("server.port"));
                System.out.println(" \n Export template to pass to the plugin registration handler: \n " + templString);
            } else {
                System.out.println("\n You can use  -h or --help for more information about usage");
            }
            if (argexc) {
                System.out.println("\n Too much arguments: " + usage);
            }
            jettyServer.join();
        }
        finally {
            jettyServer.stop();
            jettyServer.destroy();
        }
    }
}

