/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.plkexport;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Snippet {
    private String left;
    private String right;
    private String mark;
    private boolean leftMore;
    private boolean rightMore;
    private boolean cuttedMark;
    private static Pattern snippetP = Pattern.compile("^(?i)<span[^>]+class=\"(?:[^\"]* )?context-left(?:[^\"]* )?\">(.*?)</span><span[^>]+class=\"(?:[^\"]* )?match(?:[^\"]* )?\">(.+?)</span><span[^>]+class=\"(?:[^\"]* )?context-right(?:[^\"]* )?\">(.*?)</span>$");
    private static Pattern moreP = Pattern.compile("(?i)<span[^>]+class=\"more\"></span>");
    private static Pattern cuttedP = Pattern.compile("(?i)<span[^>]+class=\"cutted\"></span>");

    public Snippet(String snippetstr) {
        Matcher m = snippetP.matcher(snippetstr);
        if (m.find()) {
            this.left = m.group(1);
            this.mark = m.group(2);
            this.right = m.group(3);
            if (this.left != null) {
                m = moreP.matcher(this.left);
                if (m.find()) {
                    this.left = m.replaceAll("");
                    this.leftMore = true;
                }
                this.left = Snippet.unescapeHTML(this.left);
            }
            if ((m = cuttedP.matcher(this.mark)).find()) {
                this.mark = m.replaceAll("");
                this.cuttedMark = true;
            }
            this.mark = Snippet.unescapeHTML(this.mark.replaceAll("</?mark[^>]*>", ""));
            if (this.right != null) {
                m = moreP.matcher(this.right);
                if (m.find()) {
                    this.right = m.replaceAll("");
                    this.rightMore = true;
                }
                this.right = Snippet.unescapeHTML(this.right);
            }
        } else {
            String[] splitted = snippetstr.replaceAll("(?i)</?span[^>]*>", "").split("(?i)</?mark[^>]*>");
            if (splitted[0] != null) {
                this.left = splitted[0];
            }
            if (splitted[1] != null) {
                this.mark = splitted[1];
            }
            if (splitted[2] != null) {
                this.right = splitted[2];
            }
            return;
        }
    }

    public String getLeft() {
        return this.left;
    }

    public String getRight() {
        return this.right;
    }

    public String getMark() {
        return this.mark;
    }

    public boolean hasMoreLeft() {
        return this.leftMore;
    }

    public boolean hasMoreRight() {
        return this.rightMore;
    }

    public boolean isCutted() {
        return this.cuttedMark;
    }

    private static String unescapeHTML(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&quot;", "\"").replace("&apos;", "'").replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&");
    }
}

