/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.lang.reflect.Method;
import org.apiguardian.api.API;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.STABLE, since="5.1")
public enum JRE {
    UNDEFINED(-1),
    JAVA_8(8),
    JAVA_9(9),
    JAVA_10(10),
    JAVA_11(11),
    JAVA_12(12),
    JAVA_13(13),
    JAVA_14(14),
    JAVA_15(15),
    JAVA_16(16),
    JAVA_17(17),
    JAVA_18(18),
    JAVA_19(19),
    JAVA_20(20),
    JAVA_21(21),
    JAVA_22(22),
    JAVA_23(23),
    JAVA_24(24),
    JAVA_25(25),
    OTHER(Integer.MAX_VALUE);

    static final int UNDEFINED_VERSION = -1;
    static final int MINIMUM_VERSION = 8;
    private static final Logger logger;
    private static final int CURRENT_VERSION;
    private static final JRE CURRENT_JRE;
    private final int version;

    private static int determineCurrentVersion() {
        String javaVersion = System.getProperty("java.version");
        boolean javaVersionIsBlank = StringUtils.isBlank(javaVersion);
        if (javaVersionIsBlank) {
            logger.debug(() -> "JVM system property 'java.version' is undefined. It is therefore not possible to detect Java 8.");
        }
        if (!javaVersionIsBlank && javaVersion.startsWith("1.8")) {
            return 8;
        }
        try {
            Method versionMethod = Runtime.class.getMethod("version", new Class[0]);
            Object version = ReflectionSupport.invokeMethod(versionMethod, null, new Object[0]);
            Method majorMethod = version.getClass().getMethod("major", new Class[0]);
            return (Integer)ReflectionSupport.invokeMethod(majorMethod, version, new Object[0]);
        }
        catch (Exception ex) {
            logger.debug(ex, () -> "Failed to determine the current JRE version via java.lang.Runtime.Version.");
            return -1;
        }
    }

    private static JRE determineCurrentJre(int currentVersion) {
        switch (currentVersion) {
            case -1: {
                return UNDEFINED;
            }
            case 8: {
                return JAVA_8;
            }
            case 9: {
                return JAVA_9;
            }
            case 10: {
                return JAVA_10;
            }
            case 11: {
                return JAVA_11;
            }
            case 12: {
                return JAVA_12;
            }
            case 13: {
                return JAVA_13;
            }
            case 14: {
                return JAVA_14;
            }
            case 15: {
                return JAVA_15;
            }
            case 16: {
                return JAVA_16;
            }
            case 17: {
                return JAVA_17;
            }
            case 18: {
                return JAVA_18;
            }
            case 19: {
                return JAVA_19;
            }
            case 20: {
                return JAVA_20;
            }
            case 21: {
                return JAVA_21;
            }
            case 22: {
                return JAVA_22;
            }
            case 23: {
                return JAVA_23;
            }
            case 24: {
                return JAVA_24;
            }
            case 25: {
                return JAVA_25;
            }
        }
        return OTHER;
    }

    private JRE(int version) {
        this.version = version;
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.12")
    public int version() {
        return this.version;
    }

    public boolean isCurrentVersion() {
        return this == CURRENT_JRE;
    }

    @API(status=API.Status.DEPRECATED, since="5.12")
    @Deprecated
    public static JRE currentVersion() {
        return JRE.currentJre();
    }

    @API(status=API.Status.STABLE, since="5.12")
    public static JRE currentJre() {
        return CURRENT_JRE;
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.12")
    public static int currentVersionNumber() {
        return CURRENT_VERSION;
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.12")
    public static boolean isCurrentVersion(int version) {
        return version == CURRENT_VERSION;
    }

    static boolean isCurrentVersionWithinRange(int min, int max) {
        return CURRENT_VERSION >= min && CURRENT_VERSION <= max;
    }

    static {
        logger = LoggerFactory.getLogger(JRE.class);
        CURRENT_VERSION = JRE.determineCurrentVersion();
        CURRENT_JRE = JRE.determineCurrentJre(CURRENT_VERSION);
    }
}

