/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.EnumSet;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.Token;

final class BundleToken
implements Token {
    private final Token[] tokens;

    BundleToken(Collection<Token> tokens) {
        this.tokens = tokens.toArray(new Token[0]);
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        EnumSet<LogEntryValue> values = EnumSet.noneOf(LogEntryValue.class);
        for (Token token : this.tokens) {
            values.addAll(token.getRequiredLogEntryValues());
        }
        return values;
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        for (int i2 = 0; i2 < this.tokens.length; ++i2) {
            this.tokens[i2].render(logEntry, builder);
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        StringBuilder builder = new StringBuilder();
        this.render(logEntry, builder);
        statement.setString(index, builder.toString());
    }
}

