/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class DynamicWeights
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double[] weights_;
    private Random random_;
    private boolean clip_;
    private boolean expand_;

    public DynamicWeights(Random random) {
        this.weights_ = new double[0];
        this.random_ = random;
        this.clip_ = false;
        this.expand_ = true;
    }

    public DynamicWeights(double[] params, boolean clip, boolean expand) {
        this.weights_ = params;
        this.random_ = null;
        this.clip_ = clip;
        this.expand_ = expand;
    }

    public double[] getWeights() {
        return this.weights_;
    }

    public void setWeights(double[] weight) {
        this.weights_ = weight;
    }

    public double get(int index) {
        index = this.checkCapacity(index);
        return this.weights_[index];
    }

    private int checkCapacity(int index) {
        if (index >= this.weights_.length) {
            if (this.clip_) {
                index %= this.weights_.length;
            } else if (this.expand_) {
                int old_length = this.weights_.length;
                int new_length = Math.max(index + 10, this.weights_.length * 2 / 3);
                this.expandArray(old_length, new_length);
            }
        }
        return index;
    }

    private void expandArray(int old_length, int new_length) {
        this.weights_ = Arrays.copyOf(this.weights_, new_length);
        if (this.random_ != null) {
            for (int i = old_length; i < this.weights_.length; ++i) {
                this.weights_[i] = this.random_.nextGaussian();
            }
        }
    }

    public void increment(int index, double update) {
        int n = index = this.checkCapacity(index);
        this.weights_[n] = this.weights_[n] + update;
    }

    public void set(int index, double update) {
        index = this.checkCapacity(index);
        this.weights_[index] = update;
    }

    public int getLength() {
        return this.weights_.length;
    }

    public void setLength(int new_length) {
        this.expandArray(this.weights_.length, new_length);
    }

    public void setExapnd(boolean expand) {
        this.expand_ = false;
    }
}

