/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.plkexport;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.ids_mannheim.korap.plkexport.ExWSConf;
import de.ids_mannheim.korap.plkexport.Exporter;
import de.ids_mannheim.korap.plkexport.Util;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Properties;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.tinylog.Logger;

public class MatchAggregator {
    private final Properties prop = ExWSConf.properties(null);
    private static final ObjectMapper mapper = new ObjectMapper();
    private Writer writer;
    private File file;
    private JsonNode meta;
    private JsonNode query;
    private JsonNode collection;
    private String fname;
    private String queryString;
    private String corpusQueryString;
    private String src;
    private boolean timeExceeded = false;
    private int totalResults = -1;
    private int maxResults = -1;
    private int fetchedResults = 0;
    private EventOutput evOut;

    public String getMimeType() {
        return "text/plain";
    }

    public String getSuffix() {
        return "txt";
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public boolean hasTimeExceeded() {
        return this.timeExceeded;
    }

    public void setFileName(String fname) {
        this.fname = fname;
    }

    public String getFileName() {
        String s = this.fname;
        if (s == null) {
            s = this.queryString;
        }
        if (s == null) {
            return "export";
        }
        return Util.sanitizeFileName(s);
    }

    public void setQueryString(String query) {
        this.queryString = query;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setCorpusQueryString(String query) {
        this.corpusQueryString = query;
    }

    public String getCorpusQueryString() {
        return this.corpusQueryString;
    }

    public void setSource(String host, String path) {
        StringBuilder s = new StringBuilder(32);
        if (host != null) {
            s.append(host);
        }
        if (path != null && path.length() > 0) {
            s.append('/').append(path);
        }
        this.src = s.toString();
    }

    public void setSource(String src) {
        this.src = src;
    }

    public String getSource() {
        return this.src;
    }

    public void setMeta(JsonNode meta) {
        this.meta = meta;
    }

    public JsonNode getMeta() {
        return this.meta;
    }

    public void setQuery(JsonNode query) {
        this.query = query;
    }

    public JsonNode getQuery() {
        return this.query;
    }

    public void setCollection(JsonNode collection) {
        this.collection = collection;
    }

    public JsonNode getCollection() {
        return this.collection;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public String getExportID() {
        if (this.file == null) {
            return "";
        }
        return this.file.getName();
    }

    public void setFile(String exportID) {
        this.file = new File(this.getFileDirectory(), exportID);
    }

    public void writeHeader(Writer w) throws IOException {
    }

    public void writeFooter(Writer w) throws IOException {
    }

    public void addMatch(JsonNode n, Writer w) throws IOException {
    }

    public void setSse(EventOutput eventOutput) {
        this.evOut = eventOutput;
    }

    public void forceFile() {
        if (this.file == null) {
            try {
                File dir = this.getFileDirectory();
                this.file = File.createTempFile("idsexp-", "." + this.getSuffix(), dir);
                String s = null;
                if (this.writer != null) {
                    s = this.writer.toString();
                }
                this.writer = new BufferedWriter(new FileWriter(this.file, true));
                if (s != null) {
                    this.writer.write(s);
                }
            }
            catch (IOException e) {
                return;
            }
        }
    }

    public boolean init(String resp) throws IOException, JsonParseException {
        if (resp == null) {
            return false;
        }
        JsonParser parser = mapper.getFactory().createParser(resp);
        JsonNode root = (JsonNode)mapper.readTree(parser);
        if (root == null) {
            return false;
        }
        JsonNode meta = root.get("meta");
        this.setMeta(meta);
        this.setQuery(root.get("query"));
        this.setCollection(root.get("collection"));
        if (meta != null && meta.has("totalResults")) {
            this.totalResults = meta.get("totalResults").asInt();
            if (meta.has("timeExceeded")) {
                this.timeExceeded = meta.get("timeExceeded").asBoolean();
            }
        }
        if (this.writer == null) {
            this.file = null;
            this.writer = new StringWriter();
        }
        this.writeHeader(this.writer);
        return this.iterateThroughMatches(root.get("matches"));
    }

    public Exporter finish() throws IOException {
        this.writeFooter(this.writer);
        this.writer.close();
        return (Exporter)((Object)this);
    }

    public boolean appendMatches(String resp) throws IOException {
        this.forceFile();
        JsonParser parser = mapper.getFactory().createParser(resp);
        JsonNode root = (JsonNode)mapper.readTree(parser);
        if (root == null) {
            return false;
        }
        return this.iterateThroughMatches(root.get("matches"));
    }

    public Response.ResponseBuilder serve() {
        Response.ResponseBuilder rb;
        if (this.file == null) {
            rb = Response.ok(this.writer.toString());
        } else if (this.file.exists()) {
            final File expFile = this.file;
            try {
                final FileInputStream in = new FileInputStream(this.file);
                StreamingOutput output = new StreamingOutput(){
                    final /* synthetic */ MatchAggregator this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void write(OutputStream out) throws IOException {
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = in.read(buffer)) != -1) {
                            out.write(buffer, 0, length);
                        }
                        out.flush();
                        in.close();
                        expFile.delete();
                    }
                };
                rb = Response.ok(output);
            }
            catch (Exception e) {
                return Response.status(Response.Status.NOT_FOUND);
            }
        } else {
            return Response.status(Response.Status.NOT_FOUND);
        }
        return rb.type(this.getMimeType()).header("Content-Disposition", "attachment; filename=" + this.getFileName() + "." + this.getSuffix());
    }

    private boolean iterateThroughMatches(JsonNode mNodes) throws IOException {
        this.sendProgress();
        if (mNodes == null) {
            return false;
        }
        Iterator<JsonNode> mNode = mNodes.elements();
        while (mNode.hasNext()) {
            if (this.maxResults > 0 && this.fetchedResults >= this.maxResults) {
                return false;
            }
            this.addMatch(mNode.next(), this.writer);
            ++this.fetchedResults;
        }
        return true;
    }

    private File getFileDirectory() {
        String fileDir = this.prop.getProperty("conf.file_dir", System.getProperty("java.io.tmpdir"));
        File dir = new File(fileDir);
        if (!dir.exists()) {
            dir.mkdir();
        } else if (!dir.canWrite()) {
            fileDir = System.getProperty("java.io.tmpdir");
            System.err.println("Unable to write to directory");
            System.err.println("Fallback to " + fileDir);
            dir = new File(fileDir);
        }
        return dir;
    }

    private void sendProgress() {
        if (this.evOut == null || this.maxResults == 0) {
            return;
        }
        if (this.evOut.isClosed()) {
            return;
        }
        int calc = (int)Math.ceil((double)this.fetchedResults / (double)this.maxResults * 100.0);
        OutboundEvent.Builder eventBuilder = new OutboundEvent.Builder();
        eventBuilder.name("Progress");
        eventBuilder.data(String.valueOf(calc));
        try {
            this.evOut.write(eventBuilder.build());
        }
        catch (IOException e) {
            Logger.error(e);
            return;
        }
    }
}

