/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.wadl.internal;

import com.sun.research.ws.wadl.Application;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.ExtendedResource;
import org.glassfish.jersey.server.wadl.WadlApplicationContext;
import org.glassfish.jersey.server.wadl.internal.ApplicationDescription;
import org.glassfish.jersey.server.wadl.internal.WadlUtils;

@Singleton
@Path(value="application.wadl")
@ExtendedResource
public final class WadlResource {
    public static final String HTTPDATEFORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private volatile URI lastBaseUri;
    private volatile boolean lastDetailedWadl;
    private byte[] wadlXmlRepresentation;
    private String lastModified;
    private final Lock lock = new ReentrantLock();
    @Context
    private WadlApplicationContext wadlContext;

    public WadlResource() {
        this.lastModified = new SimpleDateFormat(HTTPDATEFORMAT, Locale.US).format(new Date());
    }

    private boolean isCached(UriInfo uriInfo, boolean detailedWadl) {
        return this.lastBaseUri != null && this.lastBaseUri.equals(uriInfo.getBaseUri()) && this.lastDetailedWadl == detailedWadl;
    }

    @Produces(value={"application/vnd.sun.wadl+xml", "application/xml"})
    @GET
    public Response getWadl(@Context UriInfo uriInfo) {
        this.lock.lock();
        try {
            if (!this.wadlContext.isWadlGenerationEnabled()) {
                Response response = Response.status(Response.Status.NOT_FOUND).build();
                return response;
            }
            boolean detailedWadl = WadlUtils.isDetailedWadlRequested(uriInfo);
            if (this.wadlXmlRepresentation == null || !this.isCached(uriInfo, detailedWadl)) {
                this.lastBaseUri = uriInfo.getBaseUri();
                this.lastDetailedWadl = detailedWadl;
                this.lastModified = new SimpleDateFormat(HTTPDATEFORMAT, Locale.US).format(new Date());
                ApplicationDescription applicationDescription = this.wadlContext.getApplication(uriInfo, detailedWadl);
                Application application = applicationDescription.getApplication();
                try {
                    Marshaller marshaller = this.wadlContext.getJAXBContext().createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", true);
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    marshaller.marshal((Object)application, os);
                    this.wadlXmlRepresentation = os.toByteArray();
                    os.close();
                }
                catch (Exception e) {
                    throw new ProcessingException("Could not marshal the wadl Application.", e);
                }
            }
            Response response = Response.ok(new ByteArrayInputStream(this.wadlXmlRepresentation)).header("Last-modified", this.lastModified).build();
            return response;
        }
        catch (Exception e) {
            throw new ProcessingException("Error generating /application.wadl.", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Produces(value={"application/xml"})
    @GET
    @Path(value="{path}")
    public Response getExternalGrammar(@Context UriInfo uriInfo, @PathParam(value="path") String path) {
        this.lock.lock();
        try {
            if (!this.wadlContext.isWadlGenerationEnabled()) {
                Response response = Response.status(Response.Status.NOT_FOUND).build();
                return response;
            }
            ApplicationDescription applicationDescription = this.wadlContext.getApplication(uriInfo, WadlUtils.isDetailedWadlRequested(uriInfo));
            ApplicationDescription.ExternalGrammar externalMetadata = applicationDescription.getExternalGrammar(path);
            if (externalMetadata == null) {
                Response response = Response.status(Response.Status.NOT_FOUND).build();
                return response;
            }
            Response response = Response.ok().type(externalMetadata.getType()).entity(externalMetadata.getContent()).build();
            return response;
        }
        catch (Exception e) {
            throw new ProcessingException(LocalizationMessages.ERROR_WADL_RESOURCE_EXTERNAL_GRAMMAR(), e);
        }
        finally {
            this.lock.unlock();
        }
    }
}

