/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet.internal;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.JerseyRequestTimeoutHandler;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.servlet.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegate;

public class ResponseWriter
implements ContainerResponseWriter {
    private static final Logger LOGGER = Logger.getLogger(ResponseWriter.class.getName());
    private final HttpServletResponse response;
    private final boolean useSetStatusOn404;
    private final boolean configSetStatusOverSendError;
    private final CompletableFuture<ContainerResponse> responseContext;
    private final AsyncContextDelegate asyncExt;
    private final JerseyRequestTimeoutHandler requestTimeoutHandler;

    public ResponseWriter(boolean useSetStatusOn404, boolean configSetStatusOverSendError, HttpServletResponse response, AsyncContextDelegate asyncExt, ScheduledExecutorService timeoutTaskExecutor) {
        this.useSetStatusOn404 = useSetStatusOn404;
        this.configSetStatusOverSendError = configSetStatusOverSendError;
        this.response = response;
        this.asyncExt = asyncExt;
        this.responseContext = new CompletableFuture();
        this.requestTimeoutHandler = new JerseyRequestTimeoutHandler(this, timeoutTaskExecutor);
    }

    @Override
    public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
        try {
            this.asyncExt.suspend();
        }
        catch (IllegalStateException ex) {
            LOGGER.log(Level.WARNING, LocalizationMessages.SERVLET_REQUEST_SUSPEND_FAILED(), ex);
            return false;
        }
        return this.requestTimeoutHandler.suspend(timeOut, timeUnit, timeoutHandler);
    }

    @Override
    public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
        this.requestTimeoutHandler.setSuspendTimeout(timeOut, timeUnit);
    }

    @Override
    public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse responseContext) throws ContainerException {
        if (this.asyncExt.isCompleted()) {
            return null;
        }
        this.responseContext.complete(responseContext);
        if (responseContext.hasEntity() && contentLength != -1L && contentLength < Integer.MAX_VALUE) {
            this.response.setContentLength((int)contentLength);
        }
        MultivaluedMap<String, String> headers = responseContext.getStringHeaders();
        for (Map.Entry e : headers.entrySet()) {
            Iterator it = ((List)e.getValue()).iterator();
            if (!it.hasNext()) continue;
            String header = (String)e.getKey();
            if (this.response.containsHeader(header)) {
                this.response.setHeader(header, (String)it.next());
            }
            while (it.hasNext()) {
                this.response.addHeader(header, (String)it.next());
            }
        }
        this.response.setStatus(responseContext.getStatus());
        if (!responseContext.hasEntity()) {
            return null;
        }
        try {
            ServletOutputStream outputStream = this.response.getOutputStream();
            return new NonCloseableOutputStreamWrapper(outputStream);
        }
        catch (IOException e) {
            throw new ContainerException(e);
        }
    }

    @Override
    public void commit() {
        try {
            this.callSendError();
        }
        finally {
            this.requestTimeoutHandler.close();
            this.asyncExt.complete();
        }
    }

    private void callSendError() {
        if (!this.configSetStatusOverSendError && !this.response.isCommitted()) {
            ContainerResponse responseContext = this.getResponseContext();
            boolean hasEntity = responseContext.hasEntity();
            Response.StatusType status = responseContext.getStatusInfo();
            if (!(hasEntity || status == null || status.getStatusCode() < 400 || this.useSetStatusOn404 && status == Response.Status.NOT_FOUND)) {
                String reason = status.getReasonPhrase();
                try {
                    if (reason == null || reason.isEmpty()) {
                        this.response.sendError(status.getStatusCode());
                    } else {
                        this.response.sendError(status.getStatusCode(), reason);
                    }
                }
                catch (IOException ex) {
                    throw new ContainerException(LocalizationMessages.EXCEPTION_SENDING_ERROR_RESPONSE(status, reason != null ? reason : "--"), ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failure(Throwable error) {
        block12: {
            try {
                if (this.response.isCommitted()) break block12;
                try {
                    int statusCode = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
                    if (this.configSetStatusOverSendError) {
                        this.response.reset();
                        this.response.setStatus(statusCode);
                    } else {
                        this.response.sendError(statusCode, "Request failed.");
                    }
                }
                catch (IllegalStateException ex) {
                    LOGGER.log(Level.FINER, "Unable to reset failed response.", ex);
                }
                catch (IOException ex) {
                    throw new ContainerException(LocalizationMessages.EXCEPTION_SENDING_ERROR_RESPONSE(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Request failed."), ex);
                }
                finally {
                    this.asyncExt.complete();
                }
            }
            finally {
                this.requestTimeoutHandler.close();
                this.responseContext.completeExceptionally(error);
                this.rethrow(error);
            }
        }
    }

    @Override
    public boolean enableResponseBuffering() {
        return true;
    }

    private void rethrow(Throwable error) {
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        throw new ContainerException(error);
    }

    public int getResponseStatus() {
        return this.getResponseContext().getStatus();
    }

    public boolean responseContextResolved() {
        return this.responseContext.isDone();
    }

    public ContainerResponse getResponseContext() {
        try {
            return this.responseContext.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new ContainerException(ex);
        }
    }

    private static class NonCloseableOutputStreamWrapper
    extends OutputStream {
        private final OutputStream delegate;

        public NonCloseableOutputStreamWrapper(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

