/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.Token;

class IndentationToken
implements Token {
    private static final int INITIAL_CAPACITY = 1024;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final Token token;
    private final char[] spaces;

    IndentationToken(Token token, int indentation) {
        this.token = token;
        this.spaces = new char[indentation];
        Arrays.fill(this.spaces, ' ');
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return this.token.getRequiredLogEntryValues();
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        StringBuilder source = new StringBuilder(1024);
        this.token.render(logEntry, source);
        int head = 0;
        int i2 = source.indexOf(NEW_LINE, head);
        while (i2 != -1) {
            builder.append(source, head, i2 + NEW_LINE.length());
            if (head < source.length()) {
                builder.append(this.spaces);
                for (head = i2 + NEW_LINE.length(); head < source.length() && source.charAt(head) == '\t'; ++head) {
                    builder.append(this.spaces);
                }
            }
            i2 = source.indexOf(NEW_LINE, head);
        }
        builder.append(source, head, source.length());
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        StringBuilder builder = new StringBuilder();
        this.render(logEntry, builder);
        statement.setString(index, builder.toString());
    }
}

