/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.Token;
import org.tinylog.runtime.RuntimeProvider;

final class UptimeToken
implements Token {
    private static final String DEFAULT_PATTERN = "HH:mm:ss";
    private static final long DECIMAL_BASE = 10L;
    private static final long MAX_FRACTION_DIGITS = 9L;
    private static final long MAX_SECOND = 60L;
    private static final long MAX_MINUTE = 60L;
    private static final long MAX_HOUR = 24L;
    private static final long SECOND_IN_NANOS = 1000000000L;
    private static final long MINUTE_IN_NANOS = 60000000000L;
    private static final long HOUR_IN_NANOS = 3600000000000L;
    private static final long DAY_IN_NANOS = 86400000000000L;
    private final boolean formatted;
    private final List<Segment> segments;

    UptimeToken() {
        this.formatted = false;
        this.segments = UptimeToken.parse(DEFAULT_PATTERN);
    }

    UptimeToken(String pattern) {
        this.formatted = true;
        this.segments = UptimeToken.parse(pattern);
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singletonList(LogEntryValue.DATE);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        long nanoseconds = logEntry.getTimestamp().calcDifferenceInNanoseconds(RuntimeProvider.getStartTime());
        this.format(builder, nanoseconds);
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        long nanoseconds = logEntry.getTimestamp().calcDifferenceInNanoseconds(RuntimeProvider.getStartTime());
        if (this.formatted) {
            StringBuilder builder = new StringBuilder();
            this.format(builder, nanoseconds);
            statement.setString(index, builder.toString());
        } else {
            statement.setLong(index, nanoseconds);
        }
    }

    private static List<Segment> parse(String pattern) {
        int i2;
        ArrayList<Segment> segments = new ArrayList<Segment>();
        long maxDivisor = 1L;
        block8: for (i2 = 0; i2 < pattern.length(); ++i2) {
            char character = pattern.charAt(i2);
            int length = UptimeToken.count(pattern, i2, character);
            switch (character) {
                case '\'': {
                    int end = pattern.indexOf(39, i2 + 1);
                    if (end == -1) {
                        segments.add(new StringSegment("'"));
                        continue block8;
                    }
                    if (end == i2 + 1) {
                        segments.add(new StringSegment("'"));
                        ++i2;
                        continue block8;
                    }
                    segments.add(new StringSegment(pattern.substring(i2 + 1, end)));
                    i2 = end;
                    continue block8;
                }
                case 'S': {
                    long divisor = (long)Math.pow(10.0, Math.max(0L, 9L - (long)length));
                    long modulo = (long)Math.pow(10.0, Math.min(9L, (long)length));
                    segments.add(new TimeSegment(length, divisor, modulo));
                    maxDivisor = Math.max(maxDivisor, divisor);
                    i2 += length - 1;
                    continue block8;
                }
                case 's': {
                    segments.add(new TimeSegment(length, 1000000000L, 60L));
                    maxDivisor = Math.max(maxDivisor, 1000000000L);
                    i2 += length - 1;
                    continue block8;
                }
                case 'm': {
                    segments.add(new TimeSegment(length, 60000000000L, 60L));
                    maxDivisor = Math.max(maxDivisor, 60000000000L);
                    i2 += length - 1;
                    continue block8;
                }
                case 'H': {
                    segments.add(new TimeSegment(length, 3600000000000L, 24L));
                    maxDivisor = Math.max(maxDivisor, 3600000000000L);
                    i2 += length - 1;
                    continue block8;
                }
                case 'd': {
                    segments.add(new TimeSegment(length, 86400000000000L, 0L));
                    maxDivisor = Math.max(maxDivisor, 86400000000000L);
                    i2 += length - 1;
                    continue block8;
                }
                default: {
                    segments.add(new StringSegment(Character.toString(character)));
                }
            }
        }
        for (i2 = 0; i2 < segments.size(); ++i2) {
            TimeSegment timeSegment;
            Segment segment = (Segment)segments.get(i2);
            if (!(segment instanceof TimeSegment) || (timeSegment = (TimeSegment)segment).divisor != maxDivisor) continue;
            segments.set(i2, new TimeSegment(timeSegment.digits, timeSegment.divisor, 0L));
        }
        return segments;
    }

    private static int count(String pattern, int start, char character) {
        int index;
        for (index = start; index < pattern.length() && pattern.charAt(index) == character; ++index) {
        }
        return index - start;
    }

    private void format(StringBuilder builder, long nanoseconds) {
        for (Segment segment : this.segments) {
            segment.render(builder, nanoseconds);
        }
    }

    private static class TimeSegment
    implements Segment {
        private final int digits;
        private final long divisor;
        private final long modulus;

        TimeSegment(int digits, long divisor, long modulus) {
            this.digits = digits;
            this.divisor = divisor;
            this.modulus = modulus;
        }

        @Override
        public void render(StringBuilder builder, long nanoseconds) {
            long result = nanoseconds / this.divisor;
            if (this.modulus > 0L) {
                result %= this.modulus;
            }
            String rendered = Long.toString(result);
            for (int i2 = 0; i2 < this.digits - rendered.length(); ++i2) {
                builder.append('0');
            }
            builder.append(rendered);
        }
    }

    private static class StringSegment
    implements Segment {
        private final String text;

        StringSegment(String text) {
            this.text = text;
        }

        @Override
        public void render(StringBuilder builder, long nanoseconds) {
            builder.append(this.text);
        }
    }

    private static interface Segment {
        public void render(StringBuilder var1, long var2);
    }
}

