/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.provider;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.tinylog.provider.ContextProvider;

public final class BundleContextProvider
implements ContextProvider {
    private final ContextProvider[] providers;

    BundleContextProvider(Collection<ContextProvider> providers) {
        this.providers = providers.toArray(new ContextProvider[0]);
    }

    @Override
    public Map<String, String> getMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (int i2 = 0; i2 < this.providers.length; ++i2) {
            mapping.putAll(this.providers[i2].getMapping());
        }
        return mapping;
    }

    @Override
    public String get(String key) {
        for (int i2 = 0; i2 < this.providers.length; ++i2) {
            String value = this.providers[i2].get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public void put(String key, Object value) {
        for (int i2 = 0; i2 < this.providers.length; ++i2) {
            this.providers[i2].put(key, value);
        }
    }

    @Override
    public void remove(String key) {
        for (int i2 = 0; i2 < this.providers.length; ++i2) {
            this.providers[i2].remove(key);
        }
    }

    @Override
    public void clear() {
        for (int i2 = 0; i2 < this.providers.length; ++i2) {
            this.providers[i2].clear();
        }
    }
}

