/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.tinylog.Level;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.FormatPatternParser;
import org.tinylog.pattern.Token;
import org.tinylog.provider.InternalLogger;
import org.tinylog.writers.AbstractFileBasedWriter;
import org.tinylog.writers.raw.ByteArrayWriter;

public final class JsonWriter
extends AbstractFileBasedWriter {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final int BUFFER_SIZE = 1024;
    private static final String FIELD_PREFIX = "field.";
    private final Charset charset;
    private final ByteArrayWriter writer;
    private final Map<String, Token> fields;
    private final boolean lineDelimitedJson;
    private StringBuilder builder;
    private boolean firstEntry;
    private int truncateSize;
    private final byte[] charsetHeaderBytes;
    private final byte[] lineFeedBytes;
    private final byte[] carriageReturnBytes;
    private final byte[] newLineBytes;
    private final byte[] spaceBytes;
    private final byte[] tabulatorBytes;
    private final byte[] commaBytes;
    private final byte[] bracketOpenBytes;
    private final byte[] bracketCloseBytes;
    private final int characterSize;

    public JsonWriter() throws IOException {
        this(Collections.emptyMap());
    }

    public JsonWriter(Map<String, String> properties) throws IOException {
        super(properties);
        String fileName = this.getFileName();
        String format = this.getStringValue("format");
        boolean append = this.getBooleanValue("append");
        boolean buffered = this.getBooleanValue("buffered");
        boolean writingThread = this.getBooleanValue("writingthread");
        this.charset = this.getCharset();
        this.writer = JsonWriter.createByteArrayWriter(fileName, append, buffered, false, false, this.charset);
        this.fields = JsonWriter.createTokens(properties);
        if (format == null || "JSON".equalsIgnoreCase(format)) {
            this.lineDelimitedJson = false;
        } else if ("LDJSON".equalsIgnoreCase(format)) {
            this.lineDelimitedJson = true;
        } else {
            this.lineDelimitedJson = false;
            InternalLogger.log(Level.WARN, "Illegal format for JSON writer: " + format);
        }
        this.charsetHeaderBytes = JsonWriter.getCharsetHeader(this.charset);
        this.lineFeedBytes = JsonWriter.removeHeader("\n".getBytes(this.charset), this.charsetHeaderBytes.length);
        this.carriageReturnBytes = JsonWriter.removeHeader("\r".getBytes(this.charset), this.charsetHeaderBytes.length);
        this.newLineBytes = JsonWriter.removeHeader(NEW_LINE.getBytes(this.charset), this.charsetHeaderBytes.length);
        this.spaceBytes = JsonWriter.removeHeader(" ".getBytes(this.charset), this.charsetHeaderBytes.length);
        this.tabulatorBytes = JsonWriter.removeHeader("\t".getBytes(this.charset), this.charsetHeaderBytes.length);
        this.commaBytes = JsonWriter.removeHeader(",".getBytes(this.charset), this.charsetHeaderBytes.length);
        this.bracketOpenBytes = JsonWriter.removeHeader("[".getBytes(this.charset), this.charsetHeaderBytes.length);
        this.bracketCloseBytes = JsonWriter.removeHeader("]".getBytes(this.charset), this.charsetHeaderBytes.length);
        this.characterSize = this.lineFeedBytes.length;
        if (this.characterSize != this.carriageReturnBytes.length || this.characterSize != this.spaceBytes.length || this.characterSize != this.tabulatorBytes.length || this.characterSize != this.commaBytes.length || this.characterSize != this.bracketOpenBytes.length || this.characterSize != this.bracketCloseBytes.length) {
            throw new IllegalArgumentException("Invalid charset " + this.charset.displayName() + ". All ASCII characters must have the same number of bytes.");
        }
        if (writingThread) {
            this.builder = new StringBuilder();
        }
        this.firstEntry = this.lineDelimitedJson || this.prepareStandardJsonFile();
        this.truncateSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(LogEntry logEntry) throws IOException {
        if (this.builder == null) {
            StringBuilder builder = new StringBuilder();
            this.addJsonObject(logEntry, builder);
            ByteArrayWriter byteArrayWriter = this.writer;
            synchronized (byteArrayWriter) {
                this.internalWrite(builder.toString().getBytes(this.charset));
            }
        } else {
            this.builder.setLength(0);
            this.addJsonObject(logEntry, this.builder);
            this.internalWrite(this.builder.toString().getBytes(this.charset));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (this.builder == null) {
            ByteArrayWriter byteArrayWriter = this.writer;
            synchronized (byteArrayWriter) {
                this.internalFlush();
            }
        } else {
            this.internalFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.builder == null) {
            ByteArrayWriter byteArrayWriter = this.writer;
            synchronized (byteArrayWriter) {
                this.internalClose();
            }
        } else {
            this.internalClose();
        }
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        EnumSet<LogEntryValue> values = EnumSet.noneOf(LogEntryValue.class);
        for (Token token : this.fields.values()) {
            values.addAll(token.getRequiredLogEntryValues());
        }
        return values;
    }

    private void addJsonObject(LogEntry logEntry, StringBuilder builder) {
        if (!this.lineDelimitedJson) {
            builder.append(NEW_LINE);
            builder.append('\t');
        }
        builder.append("{");
        if (!this.lineDelimitedJson) {
            builder.append(NEW_LINE);
        }
        Token[] tokenEntries = this.fields.values().toArray(new Token[0]);
        String[] fields = this.fields.keySet().toArray(new String[0]);
        for (int i2 = 0; i2 < tokenEntries.length; ++i2) {
            if (!this.lineDelimitedJson) {
                builder.append("\t\t");
            }
            builder.append('\"');
            builder.append(fields[i2]);
            builder.append("\": \"");
            int start = builder.length();
            Token token = tokenEntries[i2];
            token.render(logEntry, builder);
            this.escapeCharacter("\\", "\\\\", builder, start);
            this.escapeCharacter("\"", "\\\"", builder, start);
            this.escapeCharacter(NEW_LINE, "\\n", builder, start);
            this.escapeCharacter("\t", "\\t", builder, start);
            this.escapeCharacter("\b", "\\b", builder, start);
            this.escapeCharacter("\f", "\\f", builder, start);
            this.escapeCharacter("\n", "\\n", builder, start);
            this.escapeCharacter("\r", "\\r", builder, start);
            builder.append('\"');
            if (i2 + 1 >= this.fields.size()) continue;
            builder.append(",");
            if (this.lineDelimitedJson) {
                builder.append(' ');
                continue;
            }
            builder.append(NEW_LINE);
        }
        if (!this.lineDelimitedJson) {
            builder.append(NEW_LINE).append('\t');
        }
        builder.append('}');
        if (this.lineDelimitedJson) {
            builder.append(NEW_LINE);
        }
    }

    private void internalWrite(byte[] data) throws IOException {
        if (this.truncateSize > 0) {
            this.writer.truncate(this.truncateSize);
            this.truncateSize = 0;
        }
        if (this.firstEntry) {
            this.firstEntry = false;
        } else if (!this.lineDelimitedJson) {
            this.writer.write(this.commaBytes, 0, this.commaBytes.length);
        }
        this.writer.write(data, 0, data.length);
    }

    private void internalFlush() throws IOException {
        if (!this.lineDelimitedJson) {
            this.writer.write(this.newLineBytes, 0, this.newLineBytes.length);
            this.writer.write(this.bracketCloseBytes, 0, this.bracketCloseBytes.length);
        }
        this.writer.flush();
        this.truncateSize = this.lineDelimitedJson ? 0 : this.newLineBytes.length + this.bracketCloseBytes.length;
    }

    private void internalClose() throws IOException {
        this.internalFlush();
        this.writer.close();
    }

    private void escapeCharacter(String character, String replacement, StringBuilder builder, int startIndex) {
        int index = builder.indexOf(character, startIndex);
        while (index != -1) {
            builder.replace(index, index + character.length(), replacement);
            index = builder.indexOf(character, index + replacement.length());
        }
    }

    private boolean isWhitespace(byte[] data, int index) {
        return this.isPresent(data, index, this.lineFeedBytes) || this.isPresent(data, index, this.carriageReturnBytes) || this.isPresent(data, index, this.spaceBytes) || this.isPresent(data, index, this.tabulatorBytes);
    }

    private boolean isPresent(byte[] data, int index, byte[] character) {
        for (int i2 = 0; i2 < character.length; ++i2) {
            if (data[index + i2] == character[i2]) continue;
            return false;
        }
        return true;
    }

    private boolean prepareStandardJsonFile() throws IOException {
        byte[] bytes = new byte[1024];
        int numberOfBytes = this.writer.readTail(bytes, 0, 1024);
        if (numberOfBytes > this.charsetHeaderBytes.length) {
            int whitespaceIndex = numberOfBytes;
            boolean foundClosingBracket = false;
            for (int i2 = numberOfBytes - this.characterSize; i2 >= this.charsetHeaderBytes.length; i2 -= this.characterSize) {
                if (this.isPresent(bytes, i2, this.bracketCloseBytes)) {
                    foundClosingBracket = true;
                    continue;
                }
                if (!foundClosingBracket) continue;
                if (this.isWhitespace(bytes, i2)) {
                    whitespaceIndex = i2;
                    continue;
                }
                this.writer.truncate(numberOfBytes - whitespaceIndex);
                return this.isPresent(bytes, i2, this.bracketOpenBytes);
            }
            throw new IOException("Invalid JSON file. The file is missing a closing bracket for the array.");
        }
        this.writer.write(this.bracketOpenBytes, 0, this.bracketOpenBytes.length);
        return true;
    }

    private static byte[] removeHeader(byte[] bytes, int length) {
        byte[] result = new byte[bytes.length - length];
        System.arraycopy(bytes, length, result, 0, result.length);
        return result;
    }

    private static Map<String, Token> createTokens(Map<String, String> properties) {
        FormatPatternParser parser = new FormatPatternParser(properties.get("exception"));
        HashMap<String, Token> tokens = new HashMap<String, Token>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().toLowerCase(Locale.ROOT).startsWith(FIELD_PREFIX)) continue;
            tokens.put(entry.getKey().substring(FIELD_PREFIX.length()), parser.parse(entry.getValue()));
        }
        return tokens;
    }
}

