/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers.raw;

import java.io.IOException;
import java.util.Arrays;
import org.tinylog.writers.raw.ByteArrayWriter;

public class CharsetAdjustmentWriterDecorator
implements ByteArrayWriter {
    private final ByteArrayWriter writer;
    private final byte[] charsetHeader;

    public CharsetAdjustmentWriterDecorator(ByteArrayWriter writer, byte[] charsetHeader) {
        this.writer = writer;
        this.charsetHeader = Arrays.copyOf(charsetHeader, charsetHeader.length);
    }

    @Override
    public int readTail(byte[] data, int offset, int length) throws IOException {
        return this.writer.readTail(data, offset, length);
    }

    @Override
    public void write(byte[] data, int length) throws IOException {
        this.write(data, 0, length);
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (this.startsWithCharsetHeader(data, offset, length)) {
            this.writer.write(data, offset + this.charsetHeader.length, length - this.charsetHeader.length);
        } else {
            this.writer.write(data, offset, length);
        }
    }

    @Override
    public void truncate(int count) throws IOException {
        this.writer.truncate(count);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private boolean startsWithCharsetHeader(byte[] data, int offset, int length) {
        if (this.charsetHeader.length > length) {
            return false;
        }
        for (int i2 = 0; i2 < this.charsetHeader.length; ++i2) {
            if (this.charsetHeader[i2] == data[offset + i2]) continue;
            return false;
        }
        return true;
    }
}

