/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.expr.sort.SimpleTypeComparison;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class ValueConstraint {
    private final Variety variety;
    private UnicodeString lexicalForm;
    private AtomicSequence typedValue;
    private int comparisonHashCode;

    public ValueConstraint(Variety variety, UnicodeString lexicalForm) {
        this.variety = variety;
        this.lexicalForm = lexicalForm;
        if (lexicalForm != null) {
            this.typedValue = new StringValue(lexicalForm);
        }
    }

    public Variety getVariety() {
        return this.variety;
    }

    public UnicodeString getLexicalForm() {
        return this.lexicalForm;
    }

    void setLexicalForm(UnicodeString value) {
        this.lexicalForm = value;
    }

    public AtomicSequence getValue() {
        return this.typedValue;
    }

    void setValue(AtomicSequence value) {
        this.typedValue = value;
        this.comparisonHashCode = SimpleTypeComparison.getInstance().hash(value);
    }

    public boolean matches(AtomicSequence supplied) {
        SimpleTypeComparison comp = SimpleTypeComparison.getInstance();
        return comp.hash(supplied) == this.comparisonHashCode && comp.equal(this.typedValue, supplied);
    }

    public Sequence asFunction() {
        CallableDelegate constraintFunction = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return StringValue.bmp("Value Constraint");
                }
                case "variety": {
                    return StringValue.bmp(this.variety == Variety.FIXED ? "fixed" : "default");
                }
                case "value": {
                    return this.getValue() == null ? new StringValue(this.getLexicalForm()) : this.getValue();
                }
                case "lexical form": {
                    return new StringValue(this.getLexicalForm());
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)constraintFunction, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }

    boolean makeTypedValue(SchemaCompiler compiler, SimpleType stype, NamespaceResolver resolver, Location loc) throws SchemaException {
        this.lexicalForm = Whitespace.applyWhitespaceNormalization(stype.getWhitespaceAction(), this.lexicalForm);
        ConversionRules rules = compiler.getConfiguration().getConversionRules();
        ValidationFailure err = stype.validateContent(this.lexicalForm, resolver, rules);
        if (err != null) {
            String val = Err.wrap(this.lexicalForm, 4);
            compiler.error((this.variety == Variety.FIXED ? "Fixed" : "Default") + " value " + Err.wrap(val) + " does not not conform to the declared type: " + err.getMessage(), loc);
            return false;
        }
        try {
            if (stype.isNamespaceSensitive()) {
                this.setValue(stype.getTypedValue(this.lexicalForm, resolver, rules));
            } else if (stype.isAtomicType()) {
                this.setValue(Converter.convert(new StringValue(this.lexicalForm), (AtomicType)stype, rules));
            } else if (stype instanceof AnySimpleType) {
                this.setValue(new StringValue(this.lexicalForm));
            } else if (this.getValue().getLength() == 1) {
                this.setValue(stype.getTypedValue(this.lexicalForm, null, rules));
            }
            return true;
        }
        catch (XPathException e) {
            compiler.error(e.getMessage(), loc);
            return false;
        }
    }

    public boolean testFixedValue(Configuration config, UnicodeString value, SimpleType type, NamespaceResolver resolver) throws ValidationException {
        if (this.variety != Variety.FIXED) {
            return true;
        }
        AtomicSequence actual = type.getTypedValue(value, resolver, config.getConversionRules());
        SimpleTypeComparison comp = SimpleTypeComparison.getInstance();
        return comp.hash(actual) == this.comparisonHashCode && comp.equal(actual, this.getValue());
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement(this.variety == Variety.FIXED ? "fixed" : "default");
        serializer.emitAttribute("lexicalForm", this.getLexicalForm().toString());
        serializer.emitTypedValue(this.getValue());
        serializer.endElement();
    }

    public static enum Variety {
        DEFAULT,
        FIXED;

    }
}

