/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.sdoc.SaxonParam;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.str.StringView;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;

public class XSDDocumentation
extends SchemaElement {
    @Override
    public void processAllAttributes() throws SchemaException {
        this.prepareAttributes();
        if (this.getFingerprint() == 581) {
            for (NodeInfo nodeInfo : this.children()) {
                if (!(nodeInfo instanceof SaxonParam)) continue;
                ((SchemaElement)nodeInfo).processAllAttributes();
            }
        }
    }

    @Override
    protected void prepareAttributes() throws SchemaException {
        ValidationFailure vf;
        String lang;
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"source"};
        this.allowAttributes(atts, allowed);
        String source = atts.getValue(NamespaceUri.NULL, "source");
        if (this.getXSDSchema().getSchemaCompiler().getLanguageVersion() == 10 && source != null && !StandardURIChecker.getInstance().isValidURI(source)) {
            this.error("Value of source attribute must be a valid anyURI value");
        }
        if ((lang = atts.getValue(NamespaceUri.XML, "lang")) != null && (vf = StringConverter.StringToLanguage.INSTANCE.validate(StringView.tidy(lang))) != null) {
            this.error("Value of xml:lang attribute is not a valid language code");
        }
    }

    @Override
    public void validateSubtree(SchemaCompiler compiler) {
    }

    @Override
    public void validate(SchemaCompiler compiler) {
    }
}

