/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream;

import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegexMatchHandler;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.value.StringValue;

public class ManualRegexIterator
extends ManualIterator
implements RegexIterator {
    private final boolean currentItemMatches;
    private final UnicodeString[] groups;

    public ManualRegexIterator(RegexIterator base) {
        this.currentItemMatches = base.isMatching();
        this.groups = new UnicodeString[base.getNumberOfGroups() + 1];
        for (int i = 0; i < this.groups.length; ++i) {
            this.groups[i] = base.getRegexGroup(i);
        }
    }

    @Override
    public StringValue next() {
        return (StringValue)super.next();
    }

    @Override
    public int getNumberOfGroups() {
        return this.groups.length;
    }

    @Override
    public boolean isMatching() {
        return this.currentItemMatches;
    }

    @Override
    public UnicodeString getRegexGroup(int number) {
        if (number >= 0 && number < this.groups.length) {
            return this.groups[number];
        }
        return EmptyUnicodeString.getInstance();
    }

    @Override
    public void processMatchingSubstring(RegexMatchHandler action) {
        throw new UnsupportedOperationException();
    }
}

