/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.plkexport;

import com.fasterxml.jackson.databind.JsonNode;
import de.ids_mannheim.korap.plkexport.Exporter;
import de.ids_mannheim.korap.plkexport.MatchAggregator;
import java.io.IOException;
import java.io.Writer;

public class JsonExporter
extends MatchAggregator
implements Exporter {
    private boolean firstMatch = true;

    @Override
    public String getMimeType() {
        return "application/json";
    }

    @Override
    public String getSuffix() {
        return "json";
    }

    @Override
    public void writeHeader(Writer w) throws IOException {
        w.append("{");
        boolean header = false;
        if (this.getQuery() != null) {
            w.append("\"query\":").append(this.getQuery().toString());
            header = true;
        }
        if (this.getMeta() != null) {
            if (header) {
                w.append(',');
            } else {
                header = true;
            }
            w.append("\"meta\":").append(this.getMeta().toString());
        }
        if (this.getCollection() != null) {
            if (header) {
                w.append(',');
            } else {
                header = true;
            }
            w.append("\"collection\":").append(this.getCollection().toString());
        }
        if (header) {
            w.append(',');
        }
        w.append("\"matches\":[");
    }

    @Override
    public void writeFooter(Writer w) throws IOException {
        w.append("]}");
    }

    @Override
    public void addMatch(JsonNode n, Writer w) throws IOException {
        if (this.firstMatch) {
            this.firstMatch = false;
        } else {
            w.append(',');
        }
        w.append(n.toString());
    }
}

