/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ElseOfList;
import freemarker.core.Environment;
import freemarker.core.IteratorBlock;
import freemarker.core.ParameterRole;
import freemarker.core.TemplateElement;
import freemarker.core.TemplateProcessingTracer;
import freemarker.template.TemplateException;
import java.io.IOException;

class ListElseContainer
extends TemplateElement {
    private final IteratorBlock listPart;
    private final ElseOfList elsePart;

    public ListElseContainer(IteratorBlock listPart, ElseOfList elsePart) {
        this.setChildBufferCapacity(2);
        this.addChild(listPart);
        this.addChild(elsePart);
        this.listPart = listPart;
        this.elsePart = elsePart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    TemplateElement[] accept(Environment env) throws TemplateException, IOException {
        boolean hadItems;
        TemplateProcessingTracer templateProcessingTracer = env.getTemplateProcessingTracer();
        if (templateProcessingTracer == null) {
            hadItems = this.listPart.acceptWithResult(env);
        } else {
            templateProcessingTracer.enterElement(env, this.listPart);
            try {
                hadItems = this.listPart.acceptWithResult(env);
            }
            finally {
                templateProcessingTracer.exitElement(env, this.listPart);
            }
        }
        if (hadItems) {
            return null;
        }
        return new TemplateElement[]{this.elsePart};
    }

    @Override
    boolean isNestedBlockRepeater() {
        return false;
    }

    @Override
    protected String dump(boolean canonical) {
        if (canonical) {
            StringBuilder buf = new StringBuilder();
            int ln = this.getChildCount();
            for (int i2 = 0; i2 < ln; ++i2) {
                TemplateElement element = this.getChild(i2);
                buf.append(element.dump(canonical));
            }
            buf.append("</#list>");
            return buf.toString();
        }
        return this.getNodeTypeSymbol();
    }

    @Override
    String getNodeTypeSymbol() {
        return "#list-#else-container";
    }

    @Override
    int getParameterCount() {
        return 0;
    }

    @Override
    Object getParameterValue(int idx) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    ParameterRole getParameterRole(int idx) {
        throw new IndexOutOfBoundsException();
    }
}

