/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers.raw;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Map;
import org.tinylog.core.LogEntry;
import org.tinylog.writers.raw.AbstractSocketWriter;

public class UdpSocketWriter
extends AbstractSocketWriter {
    private DatagramSocket datagramSocket = new DatagramSocket();

    public UdpSocketWriter(Map<String, String> properties) throws IOException {
        super(properties);
    }

    @Override
    public void write(LogEntry logEntry) throws IOException {
        byte[] message = this.formatMessage(logEntry);
        DatagramPacket packet = new DatagramPacket(message, message.length, this.getInetAddress(), this.getPort());
        this.datagramSocket.send(packet);
    }

    @Override
    public void flush() throws Exception {
    }

    @Override
    public void close() throws Exception {
        this.datagramSocket.close();
    }
}

