/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import com.saxonica.config.EnterpriseConfiguration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;

public final class MultithreadedContextMappingIterator
implements SequenceIterator<Item<?>> {
    private FocusIterator<?> base;
    private Expression action;
    private XPathContextMinor context;
    private SequenceIterator stepIterator = null;
    private LastPositionFinder lastPositionFinder;
    private ExecutorService service;
    private BlockingQueue<Future<Sequence>> resultQueue = new LinkedBlockingQueue<Future<Sequence>>();

    public MultithreadedContextMappingIterator(Expression action, XPathContextMinor context, int threads) throws XPathException {
        this.base = context.getCurrentIterator();
        this.action = action;
        this.context = context;
        this.lastPositionFinder = context::getLast;
        EnterpriseConfiguration config = (EnterpriseConfiguration)context.getConfiguration();
        this.service = config.getMultithreadingFactory().makeExecutorService(threads);
        int n = 0;
        while (++n <= 3 * threads) {
            Object item = this.base.next();
            if (item == null) {
                return;
            }
            this.mapOneItem(context);
        }
    }

    @Override
    public Item next() throws XPathException {
        Object nextItem;
        while (true) {
            Object item;
            Future future;
            if (this.stepIterator != null) {
                nextItem = this.stepIterator.next();
                if (nextItem != null) break;
                this.stepIterator = null;
            }
            if ((future = (Future)this.resultQueue.poll()) == null) {
                this.close();
                return null;
            }
            try {
                this.stepIterator = ((Sequence)future.get()).iterate();
            }
            catch (InterruptedException e) {
                throw new XPathException(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof XPathException) {
                    throw (XPathException)e.getCause();
                }
                throw new XPathException(e);
            }
            if (this.stepIterator == null) {
                return null;
            }
            if (this.base.current() != null && (item = this.base.next()) != null) {
                this.mapOneItem(this.context);
            }
            if ((nextItem = this.stepIterator.next()) != null) break;
            this.stepIterator = null;
        }
        return nextItem;
    }

    @Override
    public void close() {
        this.base.close();
        this.service.shutdown();
    }

    @Override
    public int getProperties() {
        return 0;
    }

    private void mapOneItem(XPathContextMinor context) {
        XPathContextMajor c3 = XPathContextMajor.newThreadContext(context);
        FocusIterator<?> base = context.getCurrentIterator();
        ManualIterator manualIterator = new ManualIterator(base.current(), base.position());
        manualIterator.setLastPositionFinder(this.lastPositionFinder);
        c3.setCurrentIterator(manualIterator);
        PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
        pipe.setXPathContext(context);
        SequenceOutputter outputter = new SequenceOutputter(pipe);
        c3.setReceiver(outputter);
        int attempts = 0;
        Future<Sequence> future = null;
        while (true) {
            try {
                future = this.service.submit(() -> {
                    try {
                        return this.action.iterate(c3).materialize();
                    }
                    catch (XPathException err) {
                        this.service.shutdown();
                        throw err;
                    }
                });
            }
            catch (RejectedExecutionException e) {
                if (attempts++ < 10) {
                    try {
                        Thread.sleep(1 << attempts);
                    }
                    catch (InterruptedException e1) {
                        throw e;
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
        this.resultQueue.add(future);
    }
}

